joo.classLoader.prepare("package net.jangaroo.joounit.runner",/* {

import flexunit.framework.TestResult;

import flexunit.textui.XmlResultPrinter;*/

/**
 * TestRunner implementation for phantomjs.
 * <p>
 * The following example uses phantomjs-joo-runner.js to invoke
 * <code>PhantomJsRunner#main</code> launching
 * <code>flexunit.framework.AllFrameworkTests</code>
 * with 30 seconds timeout embedded in tests.html:
 * <code>
 *   phantomjs joo/phantomjs-joo-runner.js '{
 testSuiteName:"flexunit.framework.AllFrameworkTests",
 jooMainClass:"net.jangaroo.joounit.runner.PhantomJsRunner",
 timeout:30000,
 testsHtml:"tests.html"
 }'
 *   </code>
 * </p>
 */
"public class PhantomJsRunner",1,function($$private){var trace=joo.trace;return[ function(){

  {
    window.onerror = function net$jangaroo$joounit$runner$PhantomJsRunner$27_22(e/*:Object*/)/*:void*/{
      for(var i/*:String*/ in e){
        trace("e['" + i + ']='+e[i]);
      }
      net.jangaroo.joounit.runner.PhantomJsRunner.error(e.toString());
    };
  }},

  "static const",{ config/*:Object*/ :function(){return( {
    /**
     * if set, the specified html file is loaded by phantomjs to runt the tests
     */
    testsHtml: null,
    timeout: 3000,
    freq: 250,
    outputDir: '../surefire-reports',
    testSuiteName:null,
    outputFileName: null,
    phantom: null,
    fs:null
  });}},

  "internal static function error",function error(e/*:Object*/){
    trace("[ERROR]","phantom> ",e);
    net.jangaroo.joounit.runner.PhantomJsRunner.config.phantom.exit(1);
  },

  "internal static function getTestResultsFileName",function getTestResultsFileName()/*:String*/ {
    return net.jangaroo.joounit.runner.PhantomJsRunner.config.outputFileName ? net.jangaroo.joounit.runner.PhantomJsRunner.config.outputFileName :
            net.jangaroo.joounit.runner.PhantomJsRunner.config.outputDir + '/TEST-' + net.jangaroo.joounit.runner.PhantomJsRunner.config.testSuiteName + '.xml';
  },

  "internal static function writeResult",function writeResult(testResult/*:**/)/*: void*/{
    var f = net.jangaroo.joounit.runner.PhantomJsRunner.config.fs.open(net.jangaroo.joounit.runner.PhantomJsRunner.getTestResultsFileName(), "w");
    f.write(testResult);
    f.close();
  },

  "internal static function timedOut",function timedOut()/*:void*/ {
    net.jangaroo.joounit.runner.PhantomJsRunner.error(net.jangaroo.joounit.runner.PhantomJsRunner.config.testSuiteName + " timed out after " + net.jangaroo.joounit.runner.PhantomJsRunner.config.timeout + " ms");
  },

  "public static function main",function main(testConfig/*:Object*/)/*:void*/ {/*
    const*/var verbose/*:Boolean*/ = testConfig.verbose === "true";
    for(var key/*:String*/ in testConfig){
      net.jangaroo.joounit.runner.PhantomJsRunner.config[key] = testConfig[key];
      if(verbose) {
        trace("[INFO]:", "setting", key, ": ",testConfig[key]);
      }
    }
    window.setTimeout(net.jangaroo.joounit.runner.PhantomJsRunner.timedOut,net.jangaroo.joounit.runner.PhantomJsRunner.config.timeout);
    if(net.jangaroo.joounit.runner.PhantomJsRunner.config.testsHtml){
      trace("loading tests in HTML page");
      net.jangaroo.joounit.runner.PhantomJsRunner.runTestsHtml(net.jangaroo.joounit.runner.PhantomJsRunner.config.testsHtml);
    } else {
      trace("executing tests without HTML page");
      net.jangaroo.joounit.runner.RunnerUtils.load(net.jangaroo.joounit.runner.PhantomJsRunner.config.testSuiteName,net.jangaroo.joounit.runner.PhantomJsRunner.runTests);
    }
  },

  "internal static function runTests",function runTests()/* :void*/{
    var xmlWriter/*:XmlResultPrinter*/ = new flexunit.textui.XmlResultPrinter();
    var testResult/*:TestResult*/ = net.jangaroo.joounit.runner.RunnerUtils.run(net.jangaroo.joounit.runner.PhantomJsRunner.config.testSuiteName,
            function onComplete()/*:void*/ {
              trace('tests run: '+ testResult.runCount());
              trace('errors: '+ testResult.errorCount());
              trace('failures: '+ testResult.failureCount());

              net.jangaroo.joounit.runner.PhantomJsRunner.writeResult(xmlWriter.getXml());

              // Return the correct exit status. '0' only if all the tests passed
              net.jangaroo.joounit.runner.PhantomJsRunner.config.phantom.exit(testResult.wasSuccessful() ? 0 : 1);
            }
            , xmlWriter);
  },

  "internal static function runTestsHtml",function runTestsHtml(html/*:String*/) {/*
    const*/var page/*:Object*/ = new net.jangaroo.joounit.runner.PhantomJsRunner.config.__pageConstructor();

    // Echo the output of the tests to the Standard Output
    page.onConsoleMessage = function net$jangaroo$joounit$runner$PhantomJsRunner$107_29(msg, source, linenumber) {
      trace(msg, source, linenumber);
    };

    page.open(html, function net$jangaroo$joounit$runner$PhantomJsRunner$111_21(status/*:String*/)/*:void*/ {
      trace("runner> status: "+status);

      if (status === "success") {
        waitForCondition(function net$jangaroo$joounit$runner$PhantomJsRunner$115_26() { // wait for this to be true
          return page.evaluate(function net$jangaroo$joounit$runner$PhantomJsRunner$116_32() {
            return typeof(window["result"]) !== "undefined";
          });
        }, function net$jangaroo$joounit$runner$PhantomJsRunner$119_12() { // once done...
          // Retrieve the result of the test suite
          var resultXml = page.evaluate(function net$jangaroo$joounit$runner$PhantomJsRunner$121_41(){
            return window["result"];
          });
          trace("result: \n"+resultXml);
          net.jangaroo.joounit.runner.PhantomJsRunner.writeResult(resultXml);
          var success/*:Boolean*/ = (resultXml.indexOf('errors="0" failures="0"') > 0);
          net.jangaroo.joounit.runner.PhantomJsRunner.config.phantom.exit(success ? 0 : 1);
        });
      } else {
        trace("Could not load tests.html");
        net.jangaroo.joounit.runner.PhantomJsRunner.config.phantom.exit(1);
      }
    });

    function waitForCondition(condition/*:Function*/,callback/*:Function*/)/*:void*/{
      window.setInterval(function net$jangaroo$joounit$runner$PhantomJsRunner$136_26()/*:void*/{
        if(condition()){
          callback();
        }
      },net.jangaroo.joounit.runner.PhantomJsRunner.config.freq);
    }
  },
];},["error","getTestResultsFileName","writeResult","timedOut","main","runTests","runTestsHtml"],["net.jangaroo.joounit.runner.RunnerUtils","flexunit.textui.XmlResultPrinter"], "0.8.0", "0.9.4"
);