package net.jangaroo.joounit.runner {
import flexunit.framework.TestResult;
import flexunit.textui.Printer;
import flexunit.textui.TestRunner;

import joo.DynamicClassLoader;
import joo.getQualifiedObject;

internal class RunnerUtils {

  /**
   * Load class <code>testSuiteName</code> calling <code>onSuiteLoaded</code> when
   * the class is loaded.
   * @param testSuiteName
   * @param onSuiteLoaded
   */
  internal static native function load(testSuiteName:String, onSuiteLoaded:Function):void;

  /**
   * Obtain test suite <code>testSuiteName</code> and pass arguments to <code>TestRunner#run</code>
   * @param testSuiteName
   * @param onComplete
   * @param printer
   * @see TestRunner#run
   * @return TestResult
   */
  internal static native function run(testSuiteName:String, onComplete:Function, printer:Printer) :TestResult;

}
}