/*
	Copyright (c) 2008. Adobe Systems Incorporated.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
     * Neither the name of Adobe Systems Incorporated nor the names of its
       contributors may be used to endorse or promote products derived from this
       software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/

package flexunit.textui
{

   import flash.utils.*;
   import flexunit.framework.*;
   import flexunit.utils.*;

   public class ResultPrinter implements TestListener, Printer
   {
       public function ResultPrinter()
       {
           super();
           _progress = "";
       }

   //------------------------------------------------------------------------------

       public function print( result:TestResult, runTime:Number ):void
       {
           if ( _progress.length > 0 )
               trace( _progress );

           printHeader(runTime);
           printErrors(result);
           printFailures(result);
           printFooter(result);
       }

   //------------------------------------------------------------------------------

       public function printHeader( runTime:Number ):void
       {
           trace( "Time: " + ( runTime / 1000 ) + " seconds" );
       }

   //------------------------------------------------------------------------------

       public function printErrors( result:TestResult ):void
       {
           printDefects( result.errorsIterator(), result.errorCount(), "error" );
       }

   //------------------------------------------------------------------------------

       public function printFailures( result:TestResult ):void
       {
           printDefects( result.failuresIterator(), result.failureCount(), "failure" );
       }

   //------------------------------------------------------------------------------

       public function printDefects( defects:Iterator, count:Number, type:String ):void
       {
           if ( count == 0 )
               return;

           if ( count == 1 )
               trace( "There was " + count + " " + type + ":" );
           else
               trace( "There were " + count + " " + type + "s:");

           for ( var i:Number = 1; defects.hasNext(); i++)
           {
               printDefect( TestFailure( defects.next() ), i );
           }
       }

   //------------------------------------------------------------------------------

       private function printDefect( defect:TestFailure, count:Number ):void
       {
           printDefectHeader( defect, count );
           printDefectTrace( defect );
       }

   //------------------------------------------------------------------------------

       private function printDefectHeader( defect:TestFailure, count:Number ):void
       {
           trace( count + ") " + defect.failedTest().toString() );
       }

   //------------------------------------------------------------------------------

       private function printDefectTrace( defect:TestFailure ):void
       {
           trace( "\t" + defect.exceptionMessage() );
       }

   //------------------------------------------------------------------------------

       private function printFooter( result:TestResult ):void
       {
           if ( result.wasSuccessful() )
           {
               trace( "" );
               trace( "OK (" + result.runCount() + " test" + ( result.runCount() == 1 ? "" : "s") + ")" );
           }
           else
           {
               trace( "" );
               trace( "FAILURES!!!" );
               trace( "Tests run: " + result.runCount() +
                            ",  Failures: " + result.failureCount() +
                            ",  Errors: " + result.errorCount() );
           }
          trace( "" );
       }

   //------------------------------------------------------------------------------

       public function addError( test:Test, error:Error ):void
       {
           updateProgress( "E" );
       }

   //------------------------------------------------------------------------------

       public function addFailure( test:Test, error:AssertionFailedError ):void
       {
           updateProgress( "F" );
       }

   //------------------------------------------------------------------------------

       public function endTest( test:Test ):void
       {
       }

   //------------------------------------------------------------------------------

       public function startTest( test:Test ):void
       {
           updateProgress( "." );
       }

   //------------------------------------------------------------------------------
       private function updateProgress( lr:String ):void
       {
           _progress = _progress + lr;
           if ( _progress.length > 40 )
           {
               trace( _progress );
               _progress = "";
           }
       }

   //------------------------------------------------------------------------------

       private var _progress:String;
   }
}
