package flexunit.framework {
import flexunit.utils.Iterator;

/**
 * A <code>TestResult</code> collects the results of an executing
    * Test. It is an instance of the Collecting Parameter pattern.
    * The test framework distinguishes between <i>failures</i> and <i>errors</i>.
    * A failure is anticipated and checked for with assertions. Errors are
    * unanticipated problems.
    *
    * @see flexunit.framework.Test
 */
public class TestResult {
  public var syncToFrame:Boolean;

  public function TestResult() {
    super();
  }

  public native function run(testCase:TestCase):void;

  public native function continueRun(testCase:TestCase):void;

  public native function addError(test:Test, error:Error):void;

  public native function addFailure(test:Test, error:AssertionFailedError):void;

  public native function errorCount():Number;

  public native function errorsIterator():Iterator;

  public native function failureCount():Number;

  public native function failuresIterator():Iterator;

  public native function shouldStop():Boolean;

  public native function stop(stopTests:Boolean):void;

  public native function wasSuccessful():Boolean;

  public native function addListener(listener:TestListener):void;

  public native function removeListener(listener:TestListener):void;

  public native function runCount():Number;

  public native function startTest(test:Test):void;

  public native function endTest(test:Test):void;

  public native function get assertionsMade():Number;
}
}