joo.classLoader.prepare(/*
   Copyright (c) 2008. Adobe Systems Incorporated.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
     * Neither the name of Adobe Systems Incorporated nor the names of its
       contributors may be used to endorse or promote products derived from this
       software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/
"package flexunit.framework",/*
{
   import mx.utils.ObjectUtil;
   import mx.utils.StringUtil;*/
   
   /**
    * Base class containing static assert methods.
    */
   "public class Assert",1,function($$private){var is=joo.is,$1=flexunit.framework,$2=mx.utils;return[function(){joo.classLoader.init(flexunit.framework.AssertStringFormats);},
   
      "protected static var",{ _assertionsMade/* : Number*/ : 0},
      "private static var",{ _maxAssertionsMade/* : Number*/ : 0},
      "private static var",{ _totalAssertionsMade/* : Number*/ : 0},

      "public static function resetAssertionsMade",function resetAssertionsMade()/* : void*/
      {
         if ( flexunit.framework.Assert._assertionsMade > $$private._maxAssertionsMade )
         {
            $$private._maxAssertionsMade = flexunit.framework.Assert._assertionsMade;
         } 
         flexunit.framework.Assert._assertionsMade = 0;
      },
      
      "public static function oneAssertionHasBeenMade",function oneAssertionHasBeenMade()/* : void*/
      {
         flexunit.framework.Assert._assertionsMade++;
         $$private._totalAssertionsMade++;
      },

      "public static function resetEveryAsserionsFields",function resetEveryAsserionsFields()/* : void*/
      {
         flexunit.framework.Assert._assertionsMade = 0;
         $$private._maxAssertionsMade = 0;
         $$private._totalAssertionsMade = 0;   
      },
            
      "public static function get maxAssertionsMade",function maxAssertionsMade$get()/* : Number*/
      {
         return $$private._maxAssertionsMade;
      },
      
      "public static function get assetionsMade",function assetionsMade$get()/* : Number*/
      {
         return flexunit.framework.Assert._assertionsMade;
      },
      
      "public static function get totalAssertionsMade",function totalAssertionsMade$get()/* : Number*/
      {
         return $$private._totalAssertionsMade;
      },
      
      "public function Assert",function Assert()
      {
      },

   //---------------------------------------------------------------------------


      /**
       * Asserts that 2 values are equal.
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", expected, actual ]
       *
       */
      "public static function assertEquals",function assertEquals(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 3 )
         {
            $$private.failNotEquals( rest[ 0 ], rest[ 1 ], rest[ 2 ] );
         }
         else
         {
            $$private.failNotEquals( "", rest[ 0 ], rest[ 1 ] );
         }
      },
      
   //---------------------------------------------------------------------------


      /**
       * Asserts that 2 objects are equal.
       * This method will recursively compare properties on the nested objects.
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", expected, actual ]
       *
       */
      "public static function assertObjectEquals",function assertObjectEquals(/* ... rest*/ )/* : void*/ 
      {var rest=Array.prototype.slice.call(arguments); 
         if ( rest.length == 3 )
         {
            $$private.failObjectEquals( rest[ 0 ], rest[ 1 ], rest[ 2 ] );
         }
         else
         {
            $$private.failObjectEquals( "", rest[ 0 ], rest[ 1 ] );
         }
      }, 


   //---------------------------------------------------------------------------

      /**
       * Asserts that a string matches a regexp.
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", regexp, stringToTest ]
       *
       */
      "public static function assertMatch",function assertMatch(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 3 )
         {
            $$private.failNoMatch( rest[ 0 ], rest[ 1 ], rest[ 2 ] );
         }
         else
         {
            $$private.failNoMatch( "", rest[ 0 ], rest[ 1 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Asserts that a string doesn't match a regexp.
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", regexp, stringToTest ]
       *
       */
      "public static function assertNoMatch",function assertNoMatch(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 3 )
         {
            $$private.failMatch( rest[ 0 ], rest[ 1 ], rest[ 2 ] );
         }
         else
         {
            $$private.failMatch( "", rest[ 0 ], rest[ 1 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Asserts that the first string is contained in the second one
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", shortString, longString ]
       *
       */
      "public static function assertContained",function assertContained(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 3 )
         {
            $$private.failNotContained( rest[ 0 ], rest[ 1 ], rest[ 2 ] );
         }
         else
         {
            $$private.failNotContained( "", rest[ 0 ], rest[ 1 ] );
         }
     },

   //---------------------------------------------------------------------------

      /**
       * Asserts that the first string is not contained in the second one
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", shortString, longString ]
       *
       */
      "public static function assertNotContained",function assertNotContained(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);         
         if ( rest.length == 3 )
         {
            $$private.failContained( rest[ 0 ], rest[ 1 ], rest[ 2 ] );
         }
         else
         {
            $$private.failContained( "", rest[ 0 ], rest[ 1 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Asserts that two objects are strickly identical
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", expectedObject, actualObject ]
       *
       */
      "public static function assertStrictlyEquals",function assertStrictlyEquals(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 3 )
         {
            $$private.failNotStrictlyEquals( rest[ 0 ], rest[ 1 ], rest[ 2 ] );
         }
         else
         {
            $$private.failNotStrictlyEquals( "", rest[ 0 ], rest[ 1 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Asserts that a condition is true
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", condition ]
       *
       */
      "public static function assertTrue",function assertTrue(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 2 )
         {
            $$private.failNotTrue( rest[ 0 ], rest[ 1 ] );
         }
         else
         {
            $$private.failNotTrue( "", rest[ 0 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Asserts that a condition is false
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", condition ]
       *
       */
      "public static function assertFalse",function assertFalse(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 2 )
         {
            $$private.failTrue( rest[ 0 ], rest[ 1 ] );
         }
         else
         {
            $$private.failTrue( "", rest[ 0 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Asserts that an object is null
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", objectToTest ]
       *
       */
      "public static function assertNull",function assertNull(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 2 )
         {
            $$private.failNotNull( rest[ 0 ], rest[ 1 ] );
         }
         else
         {
            $$private.failNotNull( "", rest[ 0 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Asserts that an object is not null
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", objectToTest ]
       *
       */
      "public static function assertNotNull",function assertNotNull(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 2 )
         {
            $$private.failNull( rest[ 0 ], rest[ 1 ] );
         }
         else
         {
            $$private.failNull( "", rest[ 0 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Asserts that an object is undefined
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", objectToTest ]
       *
       */
      "public static function assertUndefined",function assertUndefined(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 2 )
         {
            $$private.failNotUndefined( rest[ 0 ], rest[ 1 ] );
         }
         else
         {
            $$private.failNotUndefined( "", rest[ 0 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Asserts that an object is not undefined
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", objectToTest ]
       *
       */
      "public static function assertNotUndefined",function assertNotUndefined(/* ... rest*/ )/* : void*/
      {var rest=Array.prototype.slice.call(arguments);
         if ( rest.length == 2 )
         {
            $$private.failUndefined( rest[ 0 ], rest[ 1 ] );
         }
         else
         {
            $$private.failUndefined( "", rest[ 0 ] );
         }
      },

   //---------------------------------------------------------------------------

      /**
       * Fails with the given message
       *
       * @param failMessage
       */
      "public static function fail",function fail( failMessage/* : String = ""*/ )/* : void*/
      {if(arguments.length<=0)failMessage="";
         throw new $1.AssertionFailedError( failMessage );
      },

   //---------------------------------------------------------------------------

      "private static function failNotEquals",function failNotEquals(
                 message/* : String*/,
                 expected/* : Object*/,
                 actual/* : Object*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( expected != actual )
         {
            if (is( expected,  Number) &&is( 
                 actual,  Number) && 
                 isNaN( Number( expected ) ) && 
                 isNaN( Number( actual ) ) )
            {
               return;
            }
            $$private.failWithUserMessage(
                message, $2.StringUtil.substitute( 
                           $1.AssertStringFormats.EXPECTED_BUT_WAS, 
                           expected, actual ) );
         }
      },
      
      "private static function failObjectEquals",function failObjectEquals(
                 message/* : String*/,
                 expected/* : Object*/,
                 actual/* : Object*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( $2.ObjectUtil.compare( expected, actual ) != 0 ) 
         { 
            $$private.failWithUserMessage(
                message, $1.AssertStringFormats.ACTUAL_OBJECT_DIFFERS );
         } 
      },

      "private static function failNoMatch",function failNoMatch(
               message/* : String*/,
               regexp/* : RegExp*/,
               string/* : String*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( ! regexp.test( string ) )
         {
           $$private.failWithUserMessage(
                  message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.NO_MATCH,
                              string, regexp.toString() ) );
         }
      },

      "private static function failMatch",function failMatch(
               message/* : String*/,
               regexp/* : RegExp*/,
               string/* : String*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( regexp.test( string ) )
         {
           $$private.failWithUserMessage(
                  message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.MATCH,
                              string, regexp.toString() ) );
         }
      },

      "private static function failNotContained",function failNotContained(
               message/* : String*/,
               shortString/* : String*/,
               longString/* : String*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( longString.indexOf( shortString ) < 0 )
         {
           $$private.failWithUserMessage(
                  message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.NOT_CONTAINED,
                              shortString, longString ) );
         }
      },

      "private static function failContained",function failContained(
               message/* : String*/,
               shortString/* : String*/,
               longString/* : String*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( longString.indexOf( shortString ) >= 0 )
         {
           $$private.failWithUserMessage(
                  message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.CONTAINED,
                              shortString, longString ) );
         }
      },

      "private static function failNotStrictlyEquals",function failNotStrictlyEquals(
                 message/* : String*/,
                 expected/* : Object*/,
                 actual/* : Object*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( expected !== actual )
         {
            $$private.failWithUserMessage(
                   message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.EXPECTED_BUT_WAS,
                              expected, actual ) );
         }
      },

      "private static function failNotTrue",function failNotTrue(
                 message/* : String*/,
                 condition/* : Boolean*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( ! condition )
         {
            $$private.failWithUserMessage(
                   message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.EXPECTED_BUT_WAS,
                              true, false ) );
         }
      },

      "private static function failTrue",function failTrue(
                 message/* : String*/,
                 condition/* : Boolean*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( condition )
         {
            $$private.failWithUserMessage(
                   message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.EXPECTED_BUT_WAS,
                              false, true ) );
         }
      },

      "private static function failNull",function failNull(
                 message/* : String*/,
                 object/* : Object*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( object == null )
         {
            $$private.failWithUserMessage(
                   message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.NULL,
                              object ) );
         }
      },

      "private static function failNotNull",function failNotNull(
                 message/* : String*/,
                 object/* : Object*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( object != null )
         {
            $$private.failWithUserMessage(
                   message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.NOT_NULL,
                              object ) );
         }
      },

      "private static function failUndefined",function failUndefined(
                 message/* : String*/,
                 object/* : Object*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( object == null )
         {
            $$private.failWithUserMessage(
                   message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.UNDEFINED,
                              object ) );
         }
      },

      "private static function failNotUndefined",function failNotUndefined(
                 message/* : String*/,
                 object/* : Object*/ )/* : void*/
      {
         flexunit.framework.Assert.oneAssertionHasBeenMade();
         
         if ( object != null )
         {
            $$private.failWithUserMessage(
                   message, $2.StringUtil.substitute( 
                              $1.AssertStringFormats.NOT_UNDEFINED,
                              object ) );
         }
      },

      "private static function failWithUserMessage",function failWithUserMessage(
                 userMessage/* : String*/,
                 failMessage/* : String*/ )/* : void*/
      {
         if ( userMessage.length > 0 )
         {
            userMessage = userMessage + " - ";
         }

         throw new $1.AssertionFailedError( userMessage + failMessage );
      },
   undefined];},["resetAssertionsMade","oneAssertionHasBeenMade","resetEveryAsserionsFields","maxAssertionsMade","assetionsMade","totalAssertionsMade","assertEquals","assertObjectEquals","assertMatch","assertNoMatch","assertContained","assertNotContained","assertStrictlyEquals","assertTrue","assertFalse","assertNull","assertNotNull","assertUndefined","assertNotUndefined","fail"],["flexunit.framework.AssertionFailedError","Number","mx.utils.StringUtil","flexunit.framework.AssertStringFormats","mx.utils.ObjectUtil"], "0.8.0", "2.0-preview-1"
);