joo.classLoader.prepare("package net.jangaroo.joounit.runner",/* {

import flash.utils.getTimer;

import flexunit.framework.AssertionFailedError;
import flexunit.framework.Test;
import flexunit.framework.TestListener;
import flexunit.framework.TestResult;
import flexunit.framework.TestSuite;
import flexunit.runner.BaseTestRunner;
import flexunit.textui.XmlResultPrinter;

import joo.DynamicClassLoader;
import joo.getQualifiedObject;*/

/**
 * TestRunner implementation for browsers (incl. phantomjs).
 * <p>
 * The following example uses phantomjs-joo-runner.js to invoke
 * <code>main</code> launching
 * <code>flexunit.framework.AllFrameworkTests</code>
 * with 30 seconds timeout:
 * <code>
 *   phantomjs joo/phantomjs-joo-runner.js '{
 *      testSuiteName:"flexunit.framework.AllFrameworkTests",
 *      jooMainClass:"net.jangaroo.joounit.runner.BrowserRunner",
 *      timeout:30000
 *   }'
 *   </code>
 * </p>
 */
"public class BrowserRunner extends flexunit.runner.BaseTestRunner",2,function($$private){var is=joo.is,trace=joo.trace,$$bound=joo.boundMethod,$1=flexunit.runner,$2=net.jangaroo.joounit.runner,$3=joo,$4=flash.utils,$5=flexunit.textui,$6=flexunit.framework;return[function(){joo.classLoader.init(joo.DynamicClassLoader);}, 

  "private var",{ testResult/*:TestResult*/:null},
  "private var",{ printer/*:XmlResultPrinter*/:null},
  "private var",{ startTime/* : int*/:0},
  "private var",{ totalTestCount/* : int*/:0},
  "private var",{ numTestsRun/* : int*/:0},

  "private var",{ outputTestResult/*:Function*/ :function(){return( function net$jangaroo$joounit$runner$BrowserRunner$40_43(result/*:String*/)/*:void*/ {
    window["result"] = result;
  });}},

  "private var",{ onComplete/*:Function*/ :function(){return( function net$jangaroo$joounit$runner$BrowserRunner$44_37(testResult/*:TestResult*/, resultXml/*:String*/)/*:void*/{
    net.jangaroo.joounit.runner.BrowserRunner.insertIntoDOM(resultXml);
  });}},

  "private var",{ testSuiteName/*:String*/:null},

  /**
   * Config params are <code>testSuiteName:String</code>
   * <code>onComplete:function(TestResult,String)</code>
   * <code>outputTestResult:function(String)</code>
   * @param config
   */
  "public function BrowserRunner",function BrowserRunner(config/*:Object*/) { $1.BaseTestRunner.call(this);this.outputTestResult$2=this.outputTestResult$2();this.onComplete$2=this.onComplete$2();
    this.testSuiteName$2 = config.testSuiteName;
    if(config.onComplete) {
      this.onComplete$2 = config.onComplete;
    }
    if(config.outputTestResult){
      this.outputTestResult$2 = config.outputTestResult;
    }
  },

  /**
   * Launch the tests.
   * @param testConfig
   */
  "public static function main",function main(config/*:Object*/)/*:void*/ {
    if(is(config,  String)){
      config = {testSuiteName:config};
    }
    new $2.BrowserRunner(config).run();
  },
  
  "internal static function suiteNotFound",function suiteNotFound(msg/*:String*/) {
    window.classLoadingError = msg; // this property is read by jangaroo-maven-plugin
    trace("[ERROR]", window.classLoadingError);
    net.jangaroo.joounit.runner.BrowserRunner.exit(false);
  },

  "internal function onSuiteLoaded",function onSuiteLoaded()/* : void*/ {
    try {
      var testSuite/*:Function*/ = $3.getQualifiedObject(this.testSuiteName$2);
      if (typeof testSuite == 'function' && typeof testSuite['suite'] == 'function') {
        trace("[INFO]","running test suite "+ this.testSuiteName$2);
        this.startTime$2 = $4.getTimer();
        this.numTestsRun$2 = 0;/*
        const*/var suite/*:TestSuite*/ = testSuite['suite']();
        this.totalTestCount$2 = suite.countTestCases();
        suite.runWithResult( this.testResult$2 );
      } else {
        net.jangaroo.joounit.runner.BrowserRunner.suiteNotFound(this.testSuiteName$2 + " is not acClass or does not have a static method 'suite'.");
      }
    } catch(e){if(is(e,Error)){
      trace("[ERROR]",e);
      net.jangaroo.joounit.runner.BrowserRunner.exit(false);
    }else throw e;}
  },

  "public function run",function run()/*:void*/{
    this.printer$2 = new $5.XmlResultPrinter(this.testSuiteName$2);
    this.testResult$2 = new $6.TestResult();
    this.testResult$2.addListener(/*TestListener*/( this.printer$2 ));
    this.testResult$2.addListener(/*TestListener*/( this ));

    var classLoader/*:DynamicClassLoader*/ = $3.DynamicClassLoader.INSTANCE;
    classLoader.debug = true;
    classLoader.classLoadErrorHandler = function net$jangaroo$joounit$runner$BrowserRunner$110_41(fullClassName/*:String*/, url/*:String*/)/*:void*/ {
      net.jangaroo.joounit.runner.BrowserRunner.suiteNotFound("Class " + fullClassName + " not found at URL [" + url + "].");
    };
    classLoader.import_(this.testSuiteName$2);
    classLoader.complete($$bound(this,"onSuiteLoaded"));
  },

  "override public function testError",function testError(test/*:Test*/, error/*:Error*/)/*:void*/ {
    trace("[ERROR]", "test in error", test, error);
  },

  "override public function testFailure",function testFailure(test/*:Test*/, error/*:AssertionFailedError*/)/*:void*/ {
    trace("[ERROR]", "test failed", test, error);
  },

  "override public function testEnded",function testEnded(test/*:Test*/)/*:void*/ {
    if (++this.numTestsRun$2 == this.totalTestCount$2)
    {
      var endTime/*:Number*/ = $4.getTimer();

      var runTime/*:Number*/ = endTime - this.startTime$2;

      this.printer$2.print( this.testResult$2, runTime );
      trace('tests run: '+ this.testResult$2.runCount() + " ("+
              'errors: '+ this.testResult$2.errorCount() + ", " +
              'failures: '+ this.testResult$2.failureCount() + ")");
      trace(this.printer$2.getXml());/*

      const*/var resultXml/*:String*/ = this.printer$2.getXml();
      this.outputTestResult$2(resultXml);
      this.onComplete$2(this.testResult$2,resultXml);
      net.jangaroo.joounit.runner.BrowserRunner.exit(this.testResult$2.wasSuccessful());
    }
  },
  
  "internal static function exit",function exit(b/*:Boolean*/)/* : void*/ {/*
    const*/var exitFunc/*:Function*/ = $3.getQualifiedObject("joo._exit"); // see phantomjs-joo-config.js
    if(exitFunc){
      exitFunc(b);
    }
  },

  "public static function insertIntoDOM",function insertIntoDOM(resultXml/*:String*/)/*:void*/ {/*
    const*/var pre/*:Element*/ = window.document.createElement('pre');
    pre.appendChild(window.document.createTextNode(resultXml));
    window.document.body.appendChild(pre);
  },
undefined];},["main","suiteNotFound","exit","insertIntoDOM"],["flexunit.runner.BaseTestRunner","String","Error","flexunit.textui.XmlResultPrinter","flexunit.framework.TestResult","flexunit.framework.TestListener","joo.DynamicClassLoader"], "0.8.0", "2.0-preview-1"
);