package net.jangaroo.joounit.runner {
import flexunit.framework.AssertionFailedError;
import flexunit.framework.Test;
import flexunit.runner.BaseTestRunner;

/**
 * A test runner that can be instantiated with several test class names and that will invoke a callback
 * when finished
 */
public class DefaultJooTestRunner extends BaseTestRunner {
  /**
   * Launch the tests.
   * @param config The test configuration like
   * <code>
   *  {
   *    "tests": ["com.mycompany.Test1", "com.mycompany.Test2"],
   *    "onComplete" : function(testSuite:TestSuite, testResult:TestResult, testResultXml:String) {...}
   *  }
   * </code>
   */
  public static native function main(config:Object):void;

  public function DefaultJooTestRunner(name:String, testClassNames:Array, onComplete:Function = null) {
    super();
  }

  public native function run():void;

  override public native function testError(test:Test, error:Error):void;

  override public native function testFailure(test:Test, error:AssertionFailedError):void;

  override public native function testEnded(test:Test):void;
}
}