package flexunit.framework {

/**
 * A <code>Test</code> can be run, with the results collected.
    *
    * @see TestResult
 */
public interface Test extends Reflective {
  /**
   * Runs the tests, populating the <code>result</code> parameter.
      * @param result The TestResult instance to be populated
   */
  function runWithResult(result:TestResult):void;

  /**
   * The number of test cases in this test.
      * @return A Number representing the count of test cases in this test.
   */
  function countTestCases():Number;

  /**
   * Returns the names of the test methods for this test.
      * @return  Array of method names for this test
   */
  function getTestMethodNames():Array;

  function toString():String;
}
}