joo.classLoader.prepare("package net.jangaroo.joounit.runner",/* {

import flexunit.framework.AssertionFailedError;
import flexunit.framework.Test;
import flexunit.framework.TestListener;
import flexunit.framework.TestResult;
import flexunit.framework.TestSuite;
import flexunit.runner.BaseTestRunner;
import flexunit.textui.XmlResultPrinter;

import joo.DynamicClassLoader;
import joo.getQualifiedObject;*/

/**
 * A test runner that can be instantiated with several test class names and that will invoke a callback
 * when finished
 */
"public class DefaultJooTestRunner extends flexunit.runner.BaseTestRunner",2,function($$private){var is=joo.is,as=joo.as,trace=joo.trace,$$bound=joo.boundMethod,$1=flexunit.runner,$2=net.jangaroo.joounit.runner,$3=flexunit.textui,$4=flexunit.framework,$5=joo;return[function(){joo.classLoader.init(joo.DynamicClassLoader,flexunit.framework.TestListener);}, 

  "private var",{ testClassNames/*:Array*/:null},

  // names of the test classes the couldn't be found
  "private var",{ testClassLoadErrors/*:Vector$object.<String>*/:null},

  "private var",{ testName/*:String*/:null},
  "private var",{ testSuite/*:TestSuite*/:null},
  "private var",{ testResult/*:TestResult*/:null},
  "private var",{ printer/*:XmlResultPrinter*/:null},
  "private var",{ startTime/* : int*/:0},
  "private var",{ totalTestCount/* : int*/:0},
  "private var",{ numTestsRun/* : int*/:0},
  "private var",{ onComplete/*:Function*/:null},

  /**
   * Launch the tests.
   * @param config The test configuration like
   * <code>
   *  {
   *    "tests": ["com.mycompany.Test1", "com.mycompany.Test2"],
   *    "onComplete" : function(testSuite:TestSuite, testResult:TestResult, testResultXml:String) {...}
   *  }
   * </code>
   */
  "public static function main",function main(config/*:Object*/)/*:void*/ {

    var name/*:String*/ = "DefaultJooTestRunner";
    var onComplete/*:Function*/;
    var testClassNames/*:Array*/ = null;
    if(is(config,  String)){
      testClassNames = [as(config,  String)];
    }
    else if(is( config['tests'],  Array) ) {
      testClassNames =as( config['tests'],  Array);
    }

    if(is( config['onComplete'],  Function) ) {
      onComplete =as( config['onComplete'],  Function);
    }
    if(is( config['name'],  String) ) {
      name = config['name'];
    }

    if( testClassNames == null ) {
      throw new Error("No test classes specified");
    }

    new $2.DefaultJooTestRunner(name, testClassNames, onComplete).run();
  },



  "public function DefaultJooTestRunner",function DefaultJooTestRunner(name/*:String*/, testClassNames/*:Array*/, onComplete/*:Function = null*/) { $1.BaseTestRunner.call(this);if(arguments.length<=2)onComplete=null;
    this.testName$2 = name;
    this.testClassNames$2 = testClassNames;
    this.onComplete$2 = onComplete;
  },

  "public function run",function run()/*:void*/ {var this$=this;

    trace("[INFO]", "Running tests: "+this.testClassNames$2);

    this.printer$2 = new $3.XmlResultPrinter(this.testName$2);
    this.testResult$2 = new $4.TestResult();
    this.testResult$2.addListener(/*TestListener*/( this.printer$2 ));
    this.testResult$2.addListener(/*TestListener*/( this ));

    // load all test classes
    this.testClassLoadErrors$2 = new Vector$object/*.<String>*/();
    var classLoader/*:DynamicClassLoader*/ = $5.DynamicClassLoader.INSTANCE;
    classLoader.debug = true;
    classLoader.classLoadErrorHandler = function net$jangaroo$joounit$runner$DefaultJooTestRunner$91_41(fullClassName/*:String*/, url/*:String*/)/*:void*/ {
      // TODO this callback doesn't seem to be working. Investigate here!
      this$.testClassLoadErrors$2.push(fullClassName);
      trace("[ERROR]: Class " + fullClassName + " not found at URL [" + url + "].");
    };
    for( var i/*:int*/ = 0; i<this.testClassNames$2.length; i++ ) {
      classLoader.import_(this.testClassNames$2[i]);
    }
    classLoader.complete($$bound(this,"onSuiteLoaded"));
  },

  // =================


  "internal function onSuiteLoaded",function onSuiteLoaded()/* : void*/ {

    // check whether a class loading problem has occurred
    if( this.testClassLoadErrors$2.length > 0 ) {
      trace("[ERROR]", "Couldn't load test classes: "+this.testClassLoadErrors$2);
      net.jangaroo.joounit.runner.DefaultJooTestRunner.exit(false);
      return;
    }

    // build a test suite from all test classes
    this.testSuite$2 = new $4.TestSuite();
    for( var i/*:int*/ = 0; i<this.testClassNames$2.length; i++ ) {

      var qualifiedTestClassName/*:String*/ = this.testClassNames$2[i];
      var testClass/*:**/ = $5.getQualifiedObject(qualifiedTestClassName);
      if( typeof testClass['suite'] == 'function') {

        // there is a static function 'suite'
        // assuming that this returns a test suite instance
        this.testSuite$2.addTest(testClass['suite']());
      }
      else if(is( testClass,  Class) ) {

        // it's a test class
        this.testSuite$2.addTestSuite(testClass);
//      var test:Test = new testClass();
//      if( !(test is Test) ) {
//        throw new Error("Class "+testClassName+" is not a test implementation");
//      }
//      testSuite.addTest(test);
      }
      else {
        throw new Error("Not a valid test class: "+qualifiedTestClassName);
      }
    }

    // run test suite
    try {

      this.startTime$2 = new Date().getTime();
      this.numTestsRun$2 = 0;
      this.totalTestCount$2 = this.testSuite$2.countTestCases();
      trace("[INFO]","Running "+this.totalTestCount$2+" tests");
      this.testSuite$2.runWithResult( this.testResult$2 );
    }
    catch(e){if(is(e,Error)){
      trace("[ERROR]",e);
      net.jangaroo.joounit.runner.DefaultJooTestRunner.exit(false);
    }else throw e;}
  },

  "override public function testError",function testError(test/*:Test*/, error/*:Error*/)/*:void*/ {
    trace("[ERROR]", "test in error", test, error);
  },

  "override public function testFailure",function testFailure(test/*:Test*/, error/*:AssertionFailedError*/)/*:void*/ {
    trace("[ERROR]", "test failed", test, error);
  },

  "override public function testEnded",function testEnded(test/*:Test*/)/*:void*/ {

    if (++this.numTestsRun$2 == this.totalTestCount$2)
    {
      var endTime/*:Number*/ = new Date().getTime();
      var runTime/*:Number*/ = endTime - this.startTime$2;

      this.printer$2.print( this.testResult$2, runTime );/*


      const*/var testResultXml/*:String*/ = this.printer$2.getXml();
      if( this.onComplete$2 != null ) {
        this.onComplete$2(this.testSuite$2, this.testResult$2, testResultXml);
      }
      else {
        trace('Tests: '+ this.testResult$2.runCount() + " ("+
                'Errors: '+ this.testResult$2.errorCount() + ", " +
                'Failures: '+ this.testResult$2.failureCount() + ")");
        trace(this.printer$2.getXml());
      }
      net.jangaroo.joounit.runner.DefaultJooTestRunner.exit(this.testResult$2.wasSuccessful());
    }
  },

  "internal static function exit",function exit(success/*:Boolean*/)/*:void*/ {
    if( success ) {
      trace("[INFO]", "Finished test execution successfully");
    }
    else {
      trace("[ERROR]", "Finished test execution with error(s)");
    }
  },
undefined];},["main","exit"],["flexunit.runner.BaseTestRunner","Array","flexunit.textui.XmlResultPrinter","flexunit.framework.TestResult","flexunit.framework.TestListener","joo.DynamicClassLoader","flexunit.framework.TestSuite","Date"], "0.8.0", "2.0.13"
);