package flexunit.framework {

[Uses("flexunit.framework.AssertionFailedError")]
[Uses("flexunit.framework.AssertStringFormats")]
/**
 * Base class containing static assert methods.
 */
public class Assert {
  protected static var _assertionsMade:Number;

  public static native function resetAssertionsMade():void;

  public static native function oneAssertionHasBeenMade():void;

  public static native function resetEveryAsserionsFields():void;

  public static native function get maxAssertionsMade():Number;

  public static native function get assetionsMade():Number;

  public static native function get totalAssertionsMade():Number;

  public function Assert() {
    super();
  }

  /**
   * Asserts that 2 values are equal.
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", expected, actual ]
   */
  public static native function assertEquals(...rest):void;

  /**
   * Asserts that 2 objects are equal.
   * This method will recursively compare properties on the nested objects.
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", expected, actual ]
   */
  public static native function assertObjectEquals(...rest):void;

  /**
   * Asserts that a string matches a regexp.
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", regexp, stringToTest ]
   */
  public static native function assertMatch(...rest):void;

  /**
   * Asserts that a string doesn't match a regexp.
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", regexp, stringToTest ]
   */
  public static native function assertNoMatch(...rest):void;

  /**
   * Asserts that the first string is contained in the second one
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", shortString, longString ]
   */
  public static native function assertContained(...rest):void;

  /**
   * Asserts that the first string is not contained in the second one
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", shortString, longString ]
   */
  public static native function assertNotContained(...rest):void;

  /**
   * Asserts that two objects are strickly identical
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", expectedObject, actualObject ]
   */
  public static native function assertStrictlyEquals(...rest):void;

  /**
   * Asserts that a condition is true
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", condition ]
   */
  public static native function assertTrue(...rest):void;

  /**
   * Asserts that a condition is false
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", condition ]
   */
  public static native function assertFalse(...rest):void;

  /**
   * Asserts that an object is null
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", objectToTest ]
   */
  public static native function assertNull(...rest):void;

  /**
   * Asserts that an object is not null
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", objectToTest ]
   */
  public static native function assertNotNull(...rest):void;

  /**
   * Asserts that an object is undefined
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", objectToTest ]
   */
  public static native function assertUndefined(...rest):void;

  /**
   * Asserts that an object is not undefined
   * The first argument can be the message when the assertion fails
   *
   * @param rest [ message = "", objectToTest ]
   */
  public static native function assertNotUndefined(...rest):void;

  /**
   * Fails with the given message
   *
   * @param failMessage
   */
  public static native function fail(failMessage:String = ""):void;
}
}