package flexunit.framework {
import flash.events.Event;
import flash.events.IEventDispatcher;

[Uses("flexunit.framework.TestCase")]
[Uses("flexunit.framework.EventfulTestCaseListener")]
[Uses("flexunit.framework.Assert")]
[Uses("flexunit.framework.AssertStringFormats")]
[Uses("flexunit.framework.AssertionFailedError")]
[Uses("flexunit.framework.Test")]
[Uses("flexunit.framework.Reflective")]
/**
 * A base class for test cases that are interested in event dispatching.
 *
 * <p>
 * The process of testing the dispatch of events typically involves four
 * stages:
 * </p>
 *
 * <ol>
 *    <li>
 *       Record the events that are expected to occur or not expected to occur
 *       during the test case using the <code>listenForEvent()</code> function.
 *    </li>
 *    <li>
 *       Perform the action under test in the same way as a normal test case.
 *    </li>
 *    <li>
 *       Assert that the expected events actually occurred using the
 *       <code>assertEvents()</code> function.
 *    </li>
 *    <li>
 *       Assert that the details of these events are correct using the
 *       <code>lastDispatchedEvent</code> and <code>dispatchedEvents</code> property
 *       getters and standard FlexUnit assertion functions.
 *    </li>
 * </ol>
 *
 * <p>
 * An example test case is shown below:
 * </p>
 *
 * <pre>
 * public function testAddPlutonium() : void
 * {
 *    // record the expected and unexpected events
 *    listenForEvent( model, TemperatureChangeEvent.TEMPERATURE_CHANGED );
 *    listenForEvent( model, EmergencyEvent.NUCLEAR_MELTDOWN, UNEXPECTED );
 *
 *    // perform the action that is being tested
 *    reactor.addPlutonium( plutonium );
 *
 *    // assert that the expected events were dispatched and the unexpected
 *    // events were not dispatched
 *    assertEvents(
 *       "The temperature change event was not dispatched or the world has ended" );
 *
 *    // assert on the details of the actual event
 *    var temperatureChangeEvent : TemperatureChangeEvent =
 *       TemperatureChangeEvent( lastDispatchedEvent );
 *
 *    var expectedTemperature : Number = 550;
 *
 *    assertEquals(
 *       "The expected temperature change did not occur.",
 *       expectedTemperature,
 *       temperatureChangeEvent.temperature );
 * }
 * </pre>
 */
public class EventfulTestCase extends flexunit.framework.TestCase {
  /**
   * Boolean to indicate the event is expected to be dispatched
   */
  public static const EVENT_EXPECTED:Boolean = true;

  /**
   * Boolean to indicate the event is not expected to be dispatched
   */
  public static const EVENT_UNEXPECTED:Boolean = false;

  /**
   * Gets the last event to actually be heard. Only expected events
   * registered through the <code>listenForEvent()</code> function
   * can be heard.
   */
  protected native function get lastDispatchedExpectedEvent():flash.events.Event;

  /**
   * Gets the events that were heard.
   */
  protected native function get dispatchedExpectedEvents():Array;

  public function EventfulTestCase(methodName:String = null) {
    super();
  }

  /**
   * Listens for an. When the <tt>assertEvents()</tt>
   * function is called, the events will be compared with the
   * actual events.
   *
   * @param source
   *    the object that is to be listened on for the dispatched event
   * @param type
   *    the type of event that the source object might dispatch
   * @param expected
   *    whether the event is expected to be dispatched or now; defaults to <code>EVENT_EXPECTED</code>
   */
  protected native function listenForEvent(source:flash.events.IEventDispatcher, type:String, expected:Boolean = flexunit.framework.EventfulTestCase.EVENT_EXPECTED):void;

  /**
   * Asserts that the expected events were dispatched and the
   * unexpected events were not dispatched. The events
   * must first be recorded using the <tt>listenForEvents()</tt>
   * method.
   *
   * @param message
   *    the user message to display when a test failure occurs
   */
  public native function assertEvents(message:String = ""):void;
}
}