package flexunit.framework {
import flash.events.Event;

/**
 * Listens for expected events, keeping track of the expected events that
 * actually occur. A helper class designed specifically for the
 * <code>EventfulTestCase</code>.
 */
public class EventfulTestCaseListener {
  /**
   * Gets a comma-separated string listing the types of events that were
   * expected.
   */
  public native function get expectedEventTypes():String;

  /**
   * Gets a comma-separated string listing the types of events that were not
   * expected.
   */
  public native function get unexpectedEventTypes():String;

  /**
   * Gets a comma-separated string listing the types of events that have
   * been heard.
   */
  public native function get dispatchedExpectedEventTypes():String;

  /**
   * Gets an array of all the events that have been heard.
   */
  public native function get dispatchedExpectedEvents():Array;

  /**
   * Gets the last event to have been heard.
   */
  public native function get lastDispatchedExpectedEvent():flash.events.Event;

  public function EventfulTestCaseListener() {
    super();
  }

  /**
   * Records an event being listened for.
   *
   * @param type
   *    the type of event
   * @param expected
   *    whether the event is expected to be dispatched or not
   */
  public native function listenForEvent(type:String, expected:Boolean):void;

  /**
   * Verifies that the expected events were heard, returning
   * <code>true</code> if so or <code>false</code> otherwise.
   */
  public native function expectedEventsDispatched():Boolean;

  /**
   * Verifies the expected event was dispatched
   */
  public native function expectedEventDispatched(expectedEvent:String):Boolean;

  /**
   * Verifies that the unexpected events were not heard, returning
   * <code>true</code> if so or <code>false</code> otherwise.
   */
  public native function unexpectedEventsNotDispatched():Boolean;

  /**
   * Verifies that the unexpected event was not dispatched
   */
  public native function unexpectedEventNotDispatched(unexpectedEvent:String):Boolean;

  /**
   * Handles an event by recording that it actually occurred.
   */
  public native function handleEvent(event:flash.events.Event):void;
}
}