package flexunit.framework {
import flexunit.utils.Iterator;

[Uses("flexunit.utils.Collection")]
[Uses("flexunit.utils.ArrayList")]
[Uses("flexunit.framework.Protectable")]
[Uses("flexunit.framework.ProtectedStartTestCase")]
[Uses("flexunit.framework.ProtectedMiddleTestCase")]
[Uses("flexunit.framework.ProtectedFinishTestCase")]
[Uses("flexunit.framework.TestFailure")]
[Uses("flexunit.framework.TestListener")]
[Uses("flexunit.framework.Assert")]
[Uses("flexunit.framework.AssertionFailedError")]
/**
 * A <code>TestResult</code> collects the results of an executing
 * Test. It is an instance of the Collecting Parameter pattern.
 * The test framework distinguishes between <i>failures</i> and <i>errors</i>.
 * A failure is anticipated and checked for with assertions. Errors are
 * unanticipated problems.
 *
 * @see flexunit.framework.Test
 */
public class TestResult {
  public var syncToFrame:Boolean;

  public function TestResult() {
    super();
  }

  public native function run(testCase:flexunit.framework.TestCase):void;

  public native function continueRun(testCase:flexunit.framework.TestCase):void;

  public native function addError(test:flexunit.framework.Test, error:Error):void;

  public native function addFailure(test:flexunit.framework.Test, error:flexunit.framework.AssertionFailedError):void;

  public native function errorCount():Number;

  public native function errorsIterator():flexunit.utils.Iterator;

  public native function failureCount():Number;

  public native function failuresIterator():flexunit.utils.Iterator;

  public native function shouldStop():Boolean;

  public native function stop(stopTests:Boolean):void;

  public native function wasSuccessful():Boolean;

  public native function addListener(listener:flexunit.framework.TestListener):void;

  public native function removeListener(listener:flexunit.framework.TestListener):void;

  public native function runCount():Number;

  public native function startTest(test:flexunit.framework.Test):void;

  public native function endTest(test:flexunit.framework.Test):void;

  public native function get assertionsMade():Number;
}
}