package net.jangaroo.joounit.runner {
import flexunit.framework.AssertionFailedError;
import flexunit.framework.Test;
import flexunit.runner.BaseTestRunner;

[Uses("flexunit.runner.BaseTestRunner")]
[Uses("flexunit.textui.XmlResultPrinter")]
[Uses("flexunit.framework.TestResult")]
[Uses("flexunit.framework.TestListener")]
/**
 * TestRunner implementation for browsers (incl. phantomjs).
 * <p>
 * The following example uses phantomjs-joo-runner.js to invoke
 * <code>main</code> launching
 * <code>flexunit.framework.AllFrameworkTests</code>
 * with 30 seconds timeout:
 * <code>
 *   phantomjs joo/phantomjs-joo-runner.js '{
 *      testSuiteName:"flexunit.framework.AllFrameworkTests",
 *      jooMainClass:"net.jangaroo.joounit.runner.BrowserRunner",
 *      timeout:30000
 *   }'
 *   </code>
 * </p>
 */
public class BrowserRunner extends flexunit.runner.BaseTestRunner {
  /**
   * Config params are <code>testSuiteName:String</code>
   * <code>onComplete:function(TestResult,String)</code>
   * <code>outputTestResult:function(String)</code>
   * @param config
   */
  public function BrowserRunner(config:Object) {
    super();
  }

  /**
   * Launch the tests.
   * @param testConfig
   */
  public static native function main(config:Object):void;

  public native function run():void;

  override public native function testError(test:flexunit.framework.Test, error:Error):void;

  override public native function testFailure(test:flexunit.framework.Test, error:flexunit.framework.AssertionFailedError):void;

  override public native function testEnded(test:flexunit.framework.Test):void;

  public static native function insertIntoDOM(resultXml:String):void;
}
}