package ext {


/**
 * Provides a registry of available Plugin <i>classes</i> indexed by a mnemonic code known as the Plugin's ptype. The <code><a href="output/Ext.Component.html#Ext.Component-xtype">xtype</a></code> provides a way to avoid instantiating child Components when creating a full, nested config object for a complete Ext page.
 <p>A child Component may be specified simply as a <i>config object</i> as long as the correct <code><a href="output/Ext.Component.html#Ext.Component-xtype">xtype</a></code> is specified so that if and when the Component needs rendering, the correct type can be looked up for lazy instantiation.</p><p>For a list of all available <code><a href="output/Ext.Component.html#Ext.Component-xtype">xtypes</a></code>, see <a href="Ext.Component.html">Ext.Component</a>.</p>
 *
 * <p>Copyright &#169; 2011 Sencha Inc.</p>
 *
 * @see ext.PluginMgrClass
 * @see http://dev.sencha.com/deploy/ext-3.3.1/docs/source/PluginMgr.html#cls-Ext.PluginMgr Ext JS source
 */
public const PluginMgr:PluginMgrClass;

}
