/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.webjars.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;

public class UnpackJarResourcesMojo
extends AbstractMojo {
    public static final String META_INF_RESOURCES = "META-INF/resources/";
    protected MavenProject project;
    private UnArchiver unarchiver;
    private File webappDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.unpack(this.webappDirectory);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to unpack javascript dependencies", (Exception)((Object)e));
        }
    }

    public void unpack(File target) throws ArchiverException {
        this.unarchiver.setOverwrite(false);
        this.unarchiver.setFileSelectors(new FileSelector[]{new MetaInfResourcesFileSelector()});
        Set<Artifact> dependencies = this.getArtifacts();
        for (Artifact dependency : dependencies) {
            this.getLog().debug((CharSequence)("Dependency: " + dependency));
            if (dependency.isOptional() || !"jar".equals(dependency.getType())) continue;
            this.unpack(this.unarchiver, dependency, target);
        }
    }

    public void unpack(UnArchiver unarchiver, Artifact artifact, File target) throws ArchiverException {
        this.getLog().debug((CharSequence)("Unpacking dependent JAR [" + artifact.getFile().getAbsolutePath() + "]'s META-INF/resources/... to " + target.getAbsolutePath()));
        unarchiver.setSourceFile(artifact.getFile());
        if (target.mkdirs()) {
            this.getLog().debug((CharSequence)("created unarchiver target directory " + target));
        }
        unarchiver.setDestDirectory(target);
        unarchiver.setOverwrite(true);
        try {
            unarchiver.extract();
        }
        catch (Exception e) {
            throw new ArchiverException("Failed to extract WebJar artifact to " + target, (Throwable)e);
        }
    }

    protected Set<Artifact> getArtifacts() {
        return this.project.getArtifacts();
    }

    private static class MetaInfResourcesFileSelector
    implements FileSelector {
        private MetaInfResourcesFileSelector() {
        }

        public boolean isSelected(FileInfo fileInfo) throws IOException {
            return fileInfo.getName().startsWith(UnpackJarResourcesMojo.META_INF_RESOURCES) && !fileInfo.isDirectory();
        }
    }
}

