/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.jazdw.rql.parser.ASTVisitor;
import net.jazdw.rql.parser.SimpleASTVisitor;

public class ASTNode
implements Iterable<Object> {
    private ASTNode parent;
    private String name;
    private final List<Object> arguments;

    public ASTNode(ASTNode parent, String name, Object ... arguments) {
        this(parent, name, Arrays.asList(arguments));
    }

    public ASTNode(ASTNode parent, String name, List<Object> arguments) {
        this.parent = parent;
        this.name = name;
        this.arguments = new ArrayList<Object>(arguments);
    }

    public <R, A> R accept(SimpleASTVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public <R, A> R accept(ASTVisitor<R, A> visitor, A param) {
        return visitor.visit(this, param);
    }

    public void removeParent() {
        this.parent = null;
        for (Object arg : this.arguments) {
            if (!(arg instanceof ASTNode)) continue;
            ((ASTNode)arg).removeParent();
        }
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public void addArgument(Object argument) {
        this.arguments.add(argument);
    }

    public Object removeLastArgument() {
        return this.arguments.remove(this.arguments.size() - 1);
    }

    public ASTNode getParent() {
        return this.parent;
    }

    public void setParent(ASTNode parent) {
        this.parent = parent;
    }

    public boolean isNameValid() {
        return this.name != null && !this.name.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public int getArgumentsSize() {
        return this.arguments.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ASTNode other = (ASTNode)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String toString() {
        return "ASTNode [parent=" + this.parent + ", name=" + this.name + ", arguments=" + this.arguments + "]";
    }

    @Override
    public Iterator<Object> iterator() {
        return this.arguments.iterator();
    }

    public String format(String format) {
        return String.format(format, this.arguments.toArray());
    }
}

