/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jazdw.rql.converter.Converter;
import net.jazdw.rql.converter.ConverterException;
import net.jazdw.rql.parser.ASTNode;
import net.jazdw.rql.parser.ASTVisitor;
import net.jazdw.rql.parser.RQLParserException;
import net.jazdw.rql.parser.RegexReplacer;
import net.jazdw.rql.parser.SimpleASTVisitor;

public final class RQLParser {
    private static final Pattern SLASHED_PATTERN = Pattern.compile("[\\+\\*\\$\\-:\\w%\\._]*\\/[\\+\\*\\$\\-:\\w%\\._\\/]*");
    private static final Pattern NORMALIZE_PATTERN = Pattern.compile("(\\([\\+\\*\\$\\-:\\w%\\._,]+\\)|[\\+\\*\\$\\-:\\w%\\._]*|)([<>!]?=(?:[\\w]*=)?|>|<)(\\([\\+\\*\\$\\-:\\w%\\._,]+\\)|[\\+\\*\\$\\-:\\w%\\._]*|)");
    private static final Pattern NODE_CREATE_PATTERN = Pattern.compile("(\\))|([&\\|,])?([\\+\\*\\$\\-:\\w%\\._]*)(\\(?)");
    private static final Map<String, String> operatorMap = new HashMap<String, String>();
    private Converter converter;

    public RQLParser() {
        this(new Converter());
    }

    public RQLParser(Converter converter) {
        this.converter = converter;
    }

    public <R> R parse(String query, SimpleASTVisitor<R> visitor) throws RQLParserException {
        ASTNode node = this.parse(query);
        return node.accept(visitor);
    }

    public <R, A> R parse(String query, ASTVisitor<R, A> visitor, A param) throws RQLParserException {
        ASTNode node = this.parse(query);
        return node.accept(visitor, param);
    }

    public ASTNode parse(String query) throws RQLParserException {
        Object arg;
        Matcher matcher;
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        if (query.startsWith("?")) {
            throw new IllegalArgumentException("query must not start with ?");
        }
        if (query.contains("/")) {
            matcher = SLASHED_PATTERN.matcher(query);
            query = new RegexReplacer(matcher){

                @Override
                public String replaceWith() {
                    return "(" + this.matcher.group().replace("/", ",") + ")";
                }
            }.replace();
        }
        matcher = NORMALIZE_PATTERN.matcher(query);
        query = new RegexReplacer(matcher){

            @Override
            public String replaceWith() {
                String property = this.matcher.group(1);
                String operator = this.matcher.group(2);
                String value = this.matcher.group(3);
                if (operator.length() < 3) {
                    String mapped = (String)operatorMap.get(operator);
                    if (mapped == null) {
                        throw new RQLParserException("Illegal operator " + operator);
                    }
                    operator = mapped;
                } else {
                    operator = operator.substring(1, operator.length() - 1);
                }
                return operator + '(' + property + "," + value + ")";
            }
        }.replace();
        final ASTNode rootNode = new ASTNode("", new Object[0]);
        matcher = NODE_CREATE_PATTERN.matcher(query);
        String leftoverCharacters = new RegexReplacer(matcher){
            ASTNode node;
            {
                super(matcher);
                this.node = rootNode;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public String replaceWith() {
                String closeBracket = this.matcher.group(1);
                String delimiter = this.matcher.group(2);
                String propertyOrValue = this.matcher.group(3);
                String openBracket = this.matcher.group(4);
                if (delimiter != null) {
                    if (delimiter.equals("&")) {
                        RQLParser.this.setConjunction(this.node, "and");
                    } else if (delimiter.equals("|")) {
                        RQLParser.this.setConjunction(this.node, "or");
                    }
                }
                if (openBracket != null && !openBracket.isEmpty()) {
                    this.node = this.node.createChildNode(propertyOrValue, new Object[0]);
                    return "";
                }
                if (closeBracket != null && !closeBracket.isEmpty()) {
                    if (this.node == null) {
                        throw new RQLParserException("Closing paranthesis without an opening paranthesis");
                    }
                    boolean isArray = !this.node.isNameValid();
                    this.node = this.node.getParent();
                    if (!isArray) return "";
                    Object last = this.node.removeLastArgument();
                    if (!(last instanceof ASTNode)) throw new RQLParserException("Argument not ASTNode");
                    this.node.addArgument(((ASTNode)last).getArguments());
                    return "";
                }
                if ((propertyOrValue == null || propertyOrValue.isEmpty()) && !",".equals(delimiter)) return "";
                try {
                    this.node.addArgument(RQLParser.this.converter.convert(propertyOrValue));
                    return "";
                }
                catch (ConverterException e) {
                    throw new RQLParserException(e);
                }
            }
        }.replace();
        if (!rootNode.isRootNode()) {
            throw new RQLParserException("Opening paranthesis without a closing paranthesis");
        }
        if (leftoverCharacters.length() > 0) {
            throw new RQLParserException("Illegal character in query string encountered " + leftoverCharacters);
        }
        rootNode.removeParents();
        if (!rootNode.isNameValid() && rootNode.getArgumentsSize() == 1 && (arg = rootNode.getArgument(0)) instanceof ASTNode) {
            return (ASTNode)arg;
        }
        return rootNode;
    }

    private void setConjunction(ASTNode node, String operator) {
        if (!node.isNameValid()) {
            node.setName(operator);
        } else if (!node.getName().equals(operator)) {
            throw new RQLParserException("Can not mix conjunctions within a group, use paranthesis around each set of same conjuctions (& and |)");
        }
    }

    static {
        operatorMap.put("=", "eq");
        operatorMap.put("==", "eq");
        operatorMap.put(">", "gt");
        operatorMap.put(">=", "ge");
        operatorMap.put("<", "lt");
        operatorMap.put("<=", "le");
        operatorMap.put("!=", "ne");
    }
}

