/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.jazdw.rql.parser.ASTVisitor;
import net.jazdw.rql.parser.SimpleASTVisitor;
import org.apache.commons.lang3.StringUtils;

public class ASTNode
implements Iterable<Object> {
    private ASTNode parent;
    private String name;
    private final List<Object> arguments;

    public ASTNode(String name, Object ... arguments) {
        this(null, name, Arrays.asList(arguments));
    }

    public ASTNode(String name, List<Object> arguments) {
        this(null, name, arguments);
    }

    public ASTNode(ASTNode parent, String name, Object ... arguments) {
        this(parent, name, Arrays.asList(arguments));
    }

    public ASTNode(ASTNode parent, String name, List<Object> arguments) {
        this.parent = parent;
        this.name = name;
        this.arguments = new ArrayList<Object>(arguments);
    }

    public <R, A> R accept(SimpleASTVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public <R, A> R accept(ASTVisitor<R, A> visitor, A param) {
        return visitor.visit(this, param);
    }

    public ASTNode removeParents() {
        this.parent = null;
        for (Object arg : this.arguments) {
            if (!(arg instanceof ASTNode)) continue;
            ((ASTNode)arg).removeParents();
        }
        return this;
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public ASTNode createChildNode(String name, Object ... arguments) {
        return this.createChildNode(name, Arrays.asList(arguments));
    }

    public ASTNode createChildNode(String name, List<Object> arguments) {
        ASTNode child = new ASTNode(this, name, arguments);
        this.arguments.add(child);
        return child;
    }

    public ASTNode addArgument(Object argument) {
        if (argument instanceof ASTNode) {
            ((ASTNode)argument).parent = this;
        }
        this.arguments.add(argument);
        return this;
    }

    public Object removeLastArgument() {
        return this.arguments.remove(this.arguments.size() - 1);
    }

    public ASTNode getParent() {
        return this.parent;
    }

    public boolean isNameValid() {
        return this.name != null && !this.name.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getArgument(int i) {
        return this.arguments.get(i);
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public int getArgumentsSize() {
        return this.arguments.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ASTNode other = (ASTNode)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String toString() {
        return this.name + "(" + StringUtils.join(this.arguments, (String)",") + ")";
    }

    @Override
    public Iterator<Object> iterator() {
        return this.arguments.iterator();
    }

    public String format(String format) {
        return String.format(format, this.arguments.toArray());
    }
}

