/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.jazdw.rql.converter.Converter;
import net.jazdw.rql.converter.ConverterException;
import net.jazdw.rql.converter.ValueConverter;
import org.apache.commons.lang3.math.NumberUtils;

class AutoValueConverter
implements ValueConverter<Object> {
    public static final Map<String, Object> DEFAULT_CONVERSIONS = new HashMap<String, Object>();
    private static final Pattern DATE_PATTERN;
    private final Map<String, Object> conversions;

    public AutoValueConverter() {
        this(DEFAULT_CONVERSIONS);
    }

    public AutoValueConverter(Map<String, Object> autoConversionMap) {
        this.conversions = new HashMap<String, Object>(autoConversionMap);
    }

    @Override
    public Object convert(String input) throws ConverterException {
        try {
            if (this.conversions.containsKey(input)) {
                return this.conversions.get(input);
            }
            try {
                if (NumberUtils.isCreatable((String)input)) {
                    return Converter.NumberConverter.INSTANCE.convert(input);
                }
            }
            catch (ConverterException converterException) {
                // empty catch block
            }
            try {
                if (DATE_PATTERN.matcher(input).matches()) {
                    return Converter.GenericDateTimeConverter.INSTANCE.convert(input);
                }
            }
            catch (ConverterException converterException) {
                // empty catch block
            }
            return input;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    static {
        DEFAULT_CONVERSIONS.put("true", Boolean.TRUE);
        DEFAULT_CONVERSIONS.put("false", Boolean.FALSE);
        DEFAULT_CONVERSIONS.put("null", null);
        DEFAULT_CONVERSIONS.put("Infinity", Double.POSITIVE_INFINITY);
        DEFAULT_CONVERSIONS.put("-Infinity", Double.NEGATIVE_INFINITY);
        DATE_PATTERN = Pattern.compile("^[0-9]{4}-(1[0-2]|0[1-9])-(3[01]|0[1-9]|[12][0-9])(T(2[0-3]|[01][0-9])(:[0-5][0-9])?(:[0-5][0-9])?(\\.[0-9][0-9]?[0-9]?)?(Z|[+-](?:2[0-3]|[01][0-9])(?::?(?:[0-5][0-9]))?)?)?$");
    }
}

