/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.converter;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.jazdw.rql.converter.AutoValueConverter;
import net.jazdw.rql.converter.ConverterException;
import net.jazdw.rql.converter.ValueConverter;
import org.apache.commons.lang3.math.NumberUtils;

public class Converter {
    private final ValueConverter<?> defaultConverter;
    private final HashMap<String, ValueConverter<?>> converterMap;
    public static final Map<String, ValueConverter<?>> CONVERTERS = new HashMap();

    public Converter() {
        this(new AutoValueConverter(), CONVERTERS);
    }

    public Converter(ValueConverter<?> defaultConverter) {
        this(defaultConverter, CONVERTERS);
    }

    public Converter(Map<String, ValueConverter<?>> converterMap) {
        this(new AutoValueConverter(), converterMap);
    }

    public Converter(ValueConverter<?> defaultConverter, Map<String, ValueConverter<?>> converterMap) {
        this.defaultConverter = defaultConverter;
        this.converterMap = new HashMap(converterMap);
    }

    public Object convert(String input) throws ConverterException {
        ValueConverter<?> converter = this.defaultConverter;
        int pos = input.indexOf(":");
        if (pos >= 0) {
            String value;
            String type = input.substring(0, pos);
            String string = value = input.length() > pos + 1 ? input.substring(pos + 1) : "";
            if (this.converterMap.containsKey(type)) {
                converter = this.converterMap.get(type);
                input = value;
            }
        }
        input = URLDecoder.decode(input.replace("+", "%2B"), StandardCharsets.UTF_8);
        return converter.convert(input);
    }

    static {
        CONVERTERS.put("number", NumberConverter.INSTANCE);
        CONVERTERS.put("epoch", EpochTimestampConverter.INSTANCE);
        CONVERTERS.put("date", GenericDateTimeConverter.INSTANCE);
        CONVERTERS.put("boolean", BooleanConverter.INSTANCE);
        CONVERTERS.put("string", StringConverter.INSTANCE);
        CONVERTERS.put("re", CaseInsensitiveRegexConverter.INSTANCE);
        CONVERTERS.put("RE", RegexConverter.INSTANCE);
    }

    public static class NumberConverter
    implements ValueConverter<Number> {
        public static final NumberConverter INSTANCE = new NumberConverter();

        @Override
        public Number convert(String input) throws ConverterException {
            try {
                return NumberUtils.createNumber((String)input);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class EpochTimestampConverter
    implements ValueConverter<Instant> {
        public static final EpochTimestampConverter INSTANCE = new EpochTimestampConverter();

        @Override
        public Instant convert(String input) throws ConverterException {
            try {
                return Instant.ofEpochMilli(Long.parseLong(input));
            }
            catch (NumberFormatException | DateTimeException e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class GenericDateTimeConverter
    implements ValueConverter<Temporal> {
        public static final GenericDateTimeConverter INSTANCE = new GenericDateTimeConverter();

        @Override
        public Temporal convert(String input) throws ConverterException {
            try {
                return ZonedDateTimeConverter.INSTANCE.convert(input);
            }
            catch (ConverterException converterException) {
                try {
                    return LocalDateTimeConverter.INSTANCE.convert(input);
                }
                catch (ConverterException converterException2) {
                    return LocalDateConverter.INSTANCE.convert(input);
                }
            }
        }
    }

    public static class BooleanConverter
    implements ValueConverter<Boolean> {
        public static final BooleanConverter INSTANCE = new BooleanConverter();

        @Override
        public Boolean convert(String input) throws ConverterException {
            try {
                return Boolean.parseBoolean(input);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class StringConverter
    implements ValueConverter<String> {
        public static final StringConverter INSTANCE = new StringConverter();

        @Override
        public String convert(String input) throws ConverterException {
            try {
                return Objects.requireNonNull(input);
            }
            catch (NullPointerException e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class CaseInsensitiveRegexConverter
    implements ValueConverter<Pattern> {
        public static final CaseInsensitiveRegexConverter INSTANCE = new CaseInsensitiveRegexConverter();

        @Override
        public Pattern convert(String input) throws ConverterException {
            try {
                return Pattern.compile(input, 66);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class RegexConverter
    implements ValueConverter<Pattern> {
        public static final RegexConverter INSTANCE = new RegexConverter();

        @Override
        public Pattern convert(String input) throws ConverterException {
            try {
                return Pattern.compile(input);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class LocalDateConverter
    implements ValueConverter<LocalDate> {
        public static final LocalDateConverter INSTANCE = new LocalDateConverter();

        @Override
        public LocalDate convert(String input) throws ConverterException {
            try {
                return LocalDate.parse(input, DateTimeFormatter.ISO_LOCAL_DATE);
            }
            catch (DateTimeParseException e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class LocalDateTimeConverter
    implements ValueConverter<LocalDateTime> {
        public static final LocalDateTimeConverter INSTANCE = new LocalDateTimeConverter();

        @Override
        public LocalDateTime convert(String input) throws ConverterException {
            try {
                return LocalDateTime.parse(input, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class ZonedDateTimeConverter
    implements ValueConverter<ZonedDateTime> {
        public static final ZonedDateTimeConverter INSTANCE = new ZonedDateTimeConverter();

        @Override
        public ZonedDateTime convert(String input) throws ConverterException {
            try {
                return ZonedDateTime.parse(input, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                throw new ConverterException(e);
            }
        }
    }
}

