/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.converter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.jazdw.rql.converter.ConverterException;
import net.jazdw.rql.converter.DefaultValueConverter;
import net.jazdw.rql.converter.ValueConverter;
import org.apache.commons.lang3.math.NumberUtils;

class AutoValueConverter
implements ValueConverter<Object> {
    public static final Map<String, Object> DEFAULT_CONVERSIONS;
    private static final Pattern DATE_PATTERN;
    private final Map<String, Object> conversions;

    public AutoValueConverter() {
        this(DEFAULT_CONVERSIONS);
    }

    public AutoValueConverter(Map<String, Object> conversions) {
        this.conversions = conversions;
    }

    @Override
    public Object convert(String textValue) {
        try {
            if (this.conversions.containsKey(textValue)) {
                return this.conversions.get(textValue);
            }
            try {
                if (NumberUtils.isCreatable((String)textValue)) {
                    return DefaultValueConverter.NumberConverter.INSTANCE.convert(textValue);
                }
            }
            catch (ConverterException converterException) {
                // empty catch block
            }
            try {
                if (DATE_PATTERN.matcher(textValue).find()) {
                    return DefaultValueConverter.GenericDateTimeConverter.INSTANCE.convert(textValue);
                }
            }
            catch (ConverterException converterException) {
                // empty catch block
            }
            return textValue;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    static {
        DATE_PATTERN = Pattern.compile("^[0-9]{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12][0-9]|3[01])(?:T|$)");
        HashMap<String, Comparable<Boolean>> defaultConversions = new HashMap<String, Comparable<Boolean>>();
        defaultConversions.put("true", Boolean.TRUE);
        defaultConversions.put("false", Boolean.FALSE);
        defaultConversions.put("null", null);
        defaultConversions.put("Infinity", Double.valueOf(Double.POSITIVE_INFINITY));
        defaultConversions.put("-Infinity", Double.valueOf(Double.NEGATIVE_INFINITY));
        DEFAULT_CONVERSIONS = Collections.unmodifiableMap(defaultConversions);
    }
}

