/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.visitor;

import java.util.Map;
import java.util.Objects;
import net.jazdw.rql.RqlBaseVisitor;
import net.jazdw.rql.RqlParser;
import net.jazdw.rql.converter.DefaultValueConverter;
import net.jazdw.rql.converter.ValueConverter;
import net.jazdw.rql.parser.ASTNode;
import net.jazdw.rql.util.DefaultTextDecoder;
import net.jazdw.rql.util.TextDecoder;
import net.jazdw.rql.visitor.ValueVisitor;

public class ASTGenerator
extends RqlBaseVisitor<ASTNode> {
    public static final Map<String, String> SHORT_OPERATOR_MAP = Map.of("=", "eq", "==", "eq", ">", "gt", ">=", "ge", "<", "lt", "<=", "le", "!=", "ne");
    private final TextDecoder decoder;
    private final ValueVisitor valueVisitor;

    public ASTGenerator() {
        this(new DefaultValueConverter());
    }

    public ASTGenerator(ValueConverter<Object> converter) {
        this(new DefaultTextDecoder(), converter);
    }

    public ASTGenerator(TextDecoder decoder, ValueConverter<Object> converter) {
        this.decoder = decoder;
        this.valueVisitor = new ValueVisitor(decoder, converter);
    }

    @Override
    public ASTNode visitQuery(RqlParser.QueryContext ctx) {
        RqlParser.ExpressionContext expression = ctx.expression();
        if (expression != null) {
            return (ASTNode)expression.accept(this);
        }
        return new ASTNode("and", new Object[0]);
    }

    @Override
    public ASTNode visitGroup(RqlParser.GroupContext ctx) {
        return (ASTNode)ctx.expression().accept(this);
    }

    @Override
    public ASTNode visitLogical(RqlParser.LogicalContext ctx) {
        String operatorName = (String)this.decoder.apply(ctx.logicalOperator().getText());
        ASTNode node = new ASTNode(operatorName, new Object[0]);
        ctx.expression().stream().map(arg_0 -> ((ASTGenerator)this).visit(arg_0)).filter(Objects::nonNull).forEach(node::addArgument);
        return node;
    }

    @Override
    public ASTNode visitAnd(RqlParser.AndContext ctx) {
        ASTNode node = new ASTNode("and", new Object[0]);
        ctx.expression().stream().map(arg_0 -> ((ASTGenerator)this).visit(arg_0)).filter(Objects::nonNull).forEach(node::addArgument);
        return node;
    }

    @Override
    public ASTNode visitOr(RqlParser.OrContext ctx) {
        ASTNode node = new ASTNode("or", new Object[0]);
        ctx.expression().stream().map(arg_0 -> ((ASTGenerator)this).visit(arg_0)).filter(Objects::nonNull).forEach(node::addArgument);
        return node;
    }

    @Override
    public ASTNode visitPredicate(RqlParser.PredicateContext ctx) {
        String operatorName = (String)this.decoder.apply(ctx.predicateOperator().getText());
        String identifier = (String)this.decoder.apply(ctx.identifier().getText());
        ASTNode node = new ASTNode(operatorName, new Object[0]);
        node.addArgument(identifier);
        ctx.value().stream().map(this.valueVisitor::visitValue).forEach(node::addArgument);
        return node;
    }

    @Override
    public ASTNode visitShortPredicate(RqlParser.ShortPredicateContext ctx) {
        String identifier = (String)this.decoder.apply(ctx.identifier().getText());
        String shortOperator = ctx.shortPredicateOperator().getText();
        String operator = SHORT_OPERATOR_MAP.get(shortOperator);
        ASTNode node = new ASTNode(operator, new Object[0]);
        node.addArgument(identifier);
        node.addArgument(this.valueVisitor.visitValue(ctx.value()));
        return node;
    }

    @Override
    public ASTNode visitFunction(RqlParser.FunctionContext ctx) {
        String functionName = (String)this.decoder.apply(ctx.functionName().getText());
        ASTNode node = new ASTNode(functionName, new Object[0]);
        ctx.value().stream().map(this.valueVisitor::visitValue).forEach(node::addArgument);
        return node;
    }
}

