/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.visitor;

import java.util.Comparator;
import java.util.function.Predicate;
import net.jazdw.rql.RqlBaseVisitor;
import net.jazdw.rql.RqlParser;
import net.jazdw.rql.converter.DefaultValueConverter;
import net.jazdw.rql.util.DefaultTextDecoder;
import net.jazdw.rql.util.LimitOffset;
import net.jazdw.rql.util.PropertyAccessor;
import net.jazdw.rql.util.StreamFilter;
import net.jazdw.rql.visitor.LimitOffsetVisitor;
import net.jazdw.rql.visitor.PredicateVisitor;
import net.jazdw.rql.visitor.SortVisitor;
import net.jazdw.rql.visitor.ValueVisitor;

public class QueryVisitor<T>
extends RqlBaseVisitor<StreamFilter<T>> {
    private final PredicateVisitor<T> predicateVisitor;
    private final SortVisitor<T> sortVisitor;
    private final LimitOffsetVisitor limitOffsetVisitor;

    public QueryVisitor(PropertyAccessor<T, Object> accessor) {
        DefaultValueConverter converter = new DefaultValueConverter();
        DefaultTextDecoder decoder = new DefaultTextDecoder();
        ValueVisitor valueVisitor = new ValueVisitor(decoder, converter);
        this.predicateVisitor = new PredicateVisitor<T>(decoder, valueVisitor, accessor);
        this.sortVisitor = new SortVisitor<T>(decoder, valueVisitor, accessor);
        this.limitOffsetVisitor = new LimitOffsetVisitor(decoder, valueVisitor);
    }

    @Override
    public StreamFilter<T> visitQuery(RqlParser.QueryContext ctx) {
        Predicate predicate = null;
        Comparator sort = null;
        Long limit = null;
        Long offset = null;
        RqlParser.ExpressionContext expression = ctx.expression();
        if (expression != null) {
            predicate = (Predicate)expression.accept(this.predicateVisitor);
            sort = (Comparator)expression.accept(this.sortVisitor);
            LimitOffset limitOffset = (LimitOffset)expression.accept(this.limitOffsetVisitor);
            if (limitOffset != null) {
                limit = limitOffset.getLimit();
                offset = limitOffset.getOffset();
            }
        }
        return new StreamFilter(predicate, sort, limit, offset);
    }
}

