/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.util;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StreamFilter<T>
implements UnaryOperator<Stream<T>> {
    private final Predicate<T> predicate;
    private final Comparator<T> sort;
    private final Long limit;
    private final Long offset;

    public StreamFilter(Predicate<T> predicate, Comparator<T> sort, Long limit, Long offset) {
        this.predicate = predicate;
        this.sort = sort;
        this.limit = limit;
        this.offset = offset;
    }

    @Override
    public Stream<T> apply(Stream<T> stream) {
        if (this.predicate != null) {
            stream = stream.filter(this.predicate);
        }
        if (this.sort != null) {
            stream = stream.sorted(this.sort);
        }
        if (this.offset != null) {
            stream = stream.skip(this.offset);
        }
        if (this.limit != null) {
            stream = stream.limit(this.limit);
        }
        return stream;
    }

    public List<T> applyList(List<T> list) {
        return this.apply(list.stream()).collect(Collectors.toList());
    }
}

