/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.visitor;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.jazdw.rql.Match;
import net.jazdw.rql.RqlBaseVisitor;
import net.jazdw.rql.RqlParser;
import net.jazdw.rql.util.PropertyAccessor;
import net.jazdw.rql.util.TextDecoder;
import net.jazdw.rql.util.ThrowWithDetailsErrorListener;
import net.jazdw.rql.util.TokenSpliterator;
import net.jazdw.rql.visitor.ValueVisitor;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;

public class PredicateVisitor<T>
extends RqlBaseVisitor<Predicate<T>> {
    public static final Map<String, Integer> SHORT_OPERATOR_MAP = Map.of("=", 14, "==", 14, ">", 18, ">=", 19, "<", 16, "<=", 17, "!=", 15);
    private final ValueVisitor valueVisitor;
    private final PropertyAccessor<T, Object> accessor;
    private final TextDecoder decoder;

    public PredicateVisitor(TextDecoder decoder, ValueVisitor valueVisitor, PropertyAccessor<T, Object> accessor) {
        this.valueVisitor = valueVisitor;
        this.accessor = accessor;
        this.decoder = decoder;
    }

    @Override
    public Predicate<T> visitGroup(RqlParser.GroupContext ctx) {
        return (Predicate)ctx.expression().accept(this);
    }

    @Override
    public Predicate<T> visitAnd(RqlParser.AndContext ctx) {
        List childPredicates = this.childPredicates(ctx.expression());
        return item -> childPredicates.stream().allMatch(p -> p.test(item));
    }

    @Override
    public Predicate<T> visitOr(RqlParser.OrContext ctx) {
        List childPredicates = this.childPredicates(ctx.expression());
        return item -> childPredicates.stream().anyMatch(p -> p.test(item));
    }

    @Override
    public Predicate<T> visitLogical(RqlParser.LogicalContext ctx) {
        List childPredicates = this.childPredicates(ctx.expression());
        Token operator = ctx.logicalOperator().getStart();
        switch (operator.getType()) {
            case 11: {
                return item -> childPredicates.stream().allMatch(p -> p.test(item));
            }
            case 12: {
                return item -> childPredicates.stream().anyMatch(p -> p.test(item));
            }
            case 13: {
                if (childPredicates.size() != 1) {
                    throw new IllegalStateException("NOT logical operator must have one child");
                }
                return childPredicates.get(0).negate();
            }
        }
        throw new UnsupportedOperationException("Unsupported logical operation type: " + operator.getText());
    }

    @Override
    public Predicate<T> visitShortPredicate(RqlParser.ShortPredicateContext ctx) {
        String propertyName = (String)this.decoder.apply(ctx.identifier().getText());
        String shortOperator = ctx.shortPredicateOperator().getText();
        int operatorTokenType = SHORT_OPERATOR_MAP.get(shortOperator);
        Object firstArg = this.valueVisitor.visitValue(ctx.value());
        return item -> {
            Object propertyValue = this.accessor.getProperty(item, propertyName);
            int result = this.accessor.getComparator(propertyName).compare(propertyValue, firstArg);
            return this.checkComparatorResult(operatorTokenType, result);
        };
    }

    @Override
    public Predicate<T> visitPredicate(RqlParser.PredicateContext ctx) {
        String propertyName = ctx.identifier() == null ? null : (String)this.decoder.apply(ctx.identifier().id.getText());
        Object firstArg = this.valueVisitor.visitValue(ctx.value(0));
        Token operator = ctx.predicateOperator().getStart();
        switch (operator.getType()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return item -> {
                    Object propertyValue = this.accessor.getProperty(item, propertyName);
                    int result = this.accessor.getComparator(propertyName).compare(propertyValue, firstArg);
                    return this.checkComparatorResult(operator.getType(), result);
                };
            }
            case 22: {
                Pattern pattern;
                if (firstArg instanceof Pattern) {
                    pattern = (Pattern)firstArg;
                } else if (firstArg instanceof String) {
                    boolean caseSensitive = false;
                    RqlParser.ValueContext secondArg = ctx.value(1);
                    if (secondArg != null) {
                        caseSensitive = (Boolean)this.valueVisitor.visitValue(secondArg);
                    }
                    CodePointCharStream inputStream = CharStreams.fromString((String)((String)firstArg));
                    Match match = new Match((CharStream)inputStream);
                    match.removeErrorListeners();
                    match.addErrorListener((ANTLRErrorListener)new ThrowWithDetailsErrorListener());
                    String regex = TokenSpliterator.stream((TokenSource)match).map(t -> {
                        switch (t.getType()) {
                            case 1: {
                                return ".";
                            }
                            case 2: {
                                return ".*";
                            }
                            case 3: {
                                return Pattern.quote("?");
                            }
                            case 4: {
                                return Pattern.quote("*");
                            }
                            case 5: {
                                return Pattern.quote("\\");
                            }
                            case 6: {
                                return Pattern.quote(t.getText());
                            }
                        }
                        throw new IllegalStateException("Unknown token type " + t.getType());
                    }).collect(Collectors.joining());
                    pattern = Pattern.compile(regex, (caseSensitive ? 0 : 2) | 0x40);
                } else {
                    throw new IllegalStateException("Must be pattern or regex");
                }
                return item -> {
                    Object propertyValue = this.accessor.getProperty(item, propertyName);
                    if (propertyValue instanceof String) {
                        String valueString = (String)propertyValue;
                        return pattern.matcher(valueString).matches();
                    }
                    return false;
                };
            }
            case 21: {
                return item -> {
                    Object propertyValue = this.accessor.getProperty(item, propertyName);
                    if (propertyValue instanceof Collection) {
                        Collection collectionValue = (Collection)propertyValue;
                        return collectionValue.contains(firstArg);
                    }
                    if (propertyValue instanceof Object[]) {
                        Object[] collectionValue = (Object[])propertyValue;
                        return Arrays.asList(collectionValue).contains(firstArg);
                    }
                    if (propertyValue instanceof String) {
                        return ((String)propertyValue).contains(String.valueOf(firstArg));
                    }
                    return false;
                };
            }
            case 20: {
                List values = firstArg instanceof List ? (List)firstArg : ctx.value().stream().map(this.valueVisitor::visitValue).collect(Collectors.toList());
                return item -> {
                    Object propertyValue = this.accessor.getProperty(item, propertyName);
                    return values.contains(propertyValue);
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported predicate type: " + operator.getText());
    }

    private List<Predicate<T>> childPredicates(List<RqlParser.ExpressionContext> arguments) {
        return arguments.stream().map(ctx -> (Predicate)ctx.accept(this)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean checkComparatorResult(int tokenType, int value) {
        switch (tokenType) {
            case 14: {
                return value == 0;
            }
            case 15: {
                return value != 0;
            }
            case 16: {
                return value < 0;
            }
            case 17: {
                return value <= 0;
            }
            case 18: {
                return value > 0;
            }
            case 19: {
                return value >= 0;
            }
        }
        throw new UnsupportedOperationException("Unsupported token type");
    }
}

