/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.visitor;

import java.util.Comparator;
import java.util.List;
import net.jazdw.rql.util.PropertyAccessor;
import net.jazdw.rql.util.TextDecoder;
import net.jazdw.rql.visitor.FunctionVisitor;
import net.jazdw.rql.visitor.ValueVisitor;

public class SortVisitor<T>
extends FunctionVisitor<Comparator<T>> {
    private final PropertyAccessor<T, Object> accessor;

    public SortVisitor(TextDecoder decoder, ValueVisitor valueVisitor, PropertyAccessor<T, Object> accessor) {
        super(decoder, valueVisitor);
        this.accessor = accessor;
    }

    @Override
    public Comparator<T> applyFunction(String functionName, List<Object> arguments) {
        if ("sort".equals(functionName)) {
            return arguments.stream().map(arg -> {
                String propertyName;
                boolean descending = false;
                String argStr = (String)arg;
                if (argStr.startsWith("-")) {
                    descending = true;
                    propertyName = argStr.substring(1);
                } else {
                    propertyName = argStr.startsWith("+") ? argStr.substring(1) : argStr;
                }
                Comparator<T> c = this.accessor.getSortComparator(propertyName);
                return descending ? c.reversed() : c;
            }).reduce(Comparator::thenComparing).orElseGet(() -> this.accessor.getSortComparator(null));
        }
        return null;
    }
}

