/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.visitor;

import java.util.stream.Collectors;
import net.jazdw.rql.RqlBaseVisitor;
import net.jazdw.rql.RqlParser;
import net.jazdw.rql.converter.DefaultValueConverter;
import net.jazdw.rql.converter.ValueConverter;
import net.jazdw.rql.util.DefaultTextDecoder;
import net.jazdw.rql.util.TextDecoder;

public class ValueVisitor
extends RqlBaseVisitor<Object> {
    private final TextDecoder decoder;
    private final ValueConverter<Object> converter;

    public ValueVisitor() {
        this(new DefaultValueConverter());
    }

    public ValueVisitor(ValueConverter<Object> converter) {
        this(new DefaultTextDecoder(), converter);
    }

    public ValueVisitor(TextDecoder decoder, ValueConverter<Object> converter) {
        this.decoder = decoder;
        this.converter = converter;
    }

    @Override
    public Object visitValue(RqlParser.ValueContext ctx) {
        if (ctx.typedValue() != null) {
            return this.visitTypedValue(ctx.typedValue());
        }
        if (ctx.arrayValue() != null) {
            return this.visitArrayValue(ctx.arrayValue());
        }
        String textValue = (String)this.decoder.apply(ctx.textValue.getText());
        return this.converter.convert(textValue);
    }

    @Override
    public Object visitTypedValue(RqlParser.TypedValueContext ctx) {
        String type = (String)this.decoder.apply(ctx.type.getText());
        String value = (String)this.decoder.apply(ctx.textValue.getText());
        return this.converter.convert(type, value);
    }

    @Override
    public Object visitArrayValue(RqlParser.ArrayValueContext ctx) {
        return ctx.value().stream().map(this::visitValue).collect(Collectors.toList());
    }
}

