package net.jqwik.api.constraints;

import java.lang.annotation.*;

import org.apiguardian.api.*;

import static org.apiguardian.api.API.Status.*;

/**
 * Constrain the range of a generated double or Double parameters.
 *
 * Applies to double or Double parameters which are also annotated with {@code @ForAll}.
 *
 * @see net.jqwik.api.ForAll
 * @see ByteRange
 * @see ShortRange
 * @see IntRange
 * @see LongRange
 * @see FloatRange
 * @see BigRange
 */
@Target({ ElementType.ANNOTATION_TYPE, ElementType.PARAMETER, ElementType.TYPE_USE })
@Retention(RetentionPolicy.RUNTIME)
@Documented
@API(status = MAINTAINED, since = "1.0")
public @interface DoubleRange {
	double min() default 0.0;

	@API(status = MAINTAINED, since = "1.2.7")
	boolean minIncluded() default true;

	double max() default Double.MAX_VALUE;

	@API(status = MAINTAINED, since = "1.2.7")
	boolean maxIncluded() default true;
}
