/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class FacadeLoader {
    private static final Logger LOG = Logger.getLogger(FacadeLoader.class.getName());

    public static <T> T load(Class<T> facadeClass) {
        try {
            T facade = null;
            for (T implementation : ServiceLoader.load(facadeClass)) {
                if (facade != null) {
                    LOG.log(Level.SEVERE, FacadeLoader.createErrorMessage(facadeClass, "Several implementations registered."));
                }
                facade = implementation;
            }
            if (facade == null) {
                LOG.log(Level.SEVERE, FacadeLoader.createErrorMessage(facadeClass, "No implementation registered."));
            }
            return facade;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, FacadeLoader.createErrorMessage(facadeClass, ""), e);
            return null;
        }
    }

    private static <T> String createErrorMessage(Class<T> facadeClass, String addendum) {
        return "Cannot load implementation for " + facadeClass.getName() + ". " + addendum;
    }
}

