/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.state;

import java.util.Objects;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;

@API(status=API.Status.EXPERIMENTAL, since="1.7.0")
public interface ChangeDetector<T> {
    public static <T> ChangeDetector<T> forImmutables() {
        return new ChangeDetector<T>(){
            private T before = null;

            @Override
            public void before(T before) {
                this.before = before;
            }

            @Override
            public boolean hasChanged(T after) {
                return !Objects.equals(this.before, after);
            }
        };
    }

    @API(status=API.Status.INTERNAL)
    public static ChangeDetector<@Nullable Object> alwaysTrue() {
        return new ChangeDetector<Object>(){

            @Override
            public void before(@Nullable Object before) {
            }

            @Override
            public boolean hasChanged(@Nullable Object after) {
                return true;
            }
        };
    }

    public void before(T var1);

    public boolean hasChanged(T var1);
}

