/*
 * Decompiled with CFR 0.152.
 */
package net.kindleit.gae;

import com.google.appengine.tools.admin.AppCfg;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.kindleit.gae.PasswordExpectOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EngineGoalBase
extends AbstractMojo {
    private static final String GAE_PROPS = "gae.properties";
    private static final String INTERRUPTED_EXCEPTION = "Interrupted waiting for process supervisor thread to finish";
    protected static final String[] ARG_TYPE = new String[0];
    protected Settings settings;
    protected String appDir;
    protected String sdkDir;
    protected boolean splitJars;
    @Deprecated
    protected String emailAccount;
    protected String serverId;
    protected String uploadServer;
    protected String hostString;
    protected boolean keepTempUploadDir;
    protected boolean passIn;
    protected String proxy;
    protected boolean wait;
    protected int monitorPort;
    protected String monitorKey;
    protected Properties gaeProperties = new Properties();

    public EngineGoalBase() {
        try {
            this.gaeProperties.load(EngineGoalBase.class.getResourceAsStream(GAE_PROPS));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load version", e);
        }
    }

    protected boolean hasServerSettings() {
        if (this.serverId == null) {
            return false;
        }
        Server srv = this.settings.getServer(this.serverId);
        return srv != null;
    }

    protected final void runAppCfg(String command, String ... commandArguments) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getAppCfgArgs());
        args.add(command);
        args.addAll(Arrays.asList(commandArguments));
        this.assureSystemProperties();
        this.getLog().debug((CharSequence)("execute AppCfg " + ((Object)args).toString()));
        if (this.hasServerSettings() && this.settings.getServer(this.serverId).getPassword() != null) {
            this.forkPasswordExpectThread(args.toArray(ARG_TYPE), this.settings.getServer(this.serverId).getPassword());
        } else {
            AppCfg.main((String[])args.toArray(ARG_TYPE));
        }
    }

    private void forkPasswordExpectThread(final String[] args, final String password) {
        this.getLog().info((CharSequence)("Use Settings configuration from server id {" + this.serverId + "}"));
        final ThreadGroup threads = new ThreadGroup("AppCfgThreadGroup");
        Thread thread = new Thread(threads, "AppCfgMainThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PipedOutputStream stdin;
                PrintStream outOrig = System.out;
                InputStream inOrig = System.in;
                PipedInputStream inReplace = new PipedInputStream();
                try {
                    stdin = new PipedOutputStream(inReplace);
                }
                catch (IOException e) {
                    EngineGoalBase.this.getLog().error((CharSequence)"Unable to redirect input", (Throwable)e);
                    return;
                }
                System.setIn(inReplace);
                final BufferedWriter stdinWriter = new BufferedWriter(new OutputStreamWriter(stdin));
                System.setOut(new PrintStream(new PasswordExpectOutputStream(threads, outOrig, new Runnable(){

                    public void run() {
                        try {
                            stdinWriter.write(password);
                            stdinWriter.newLine();
                            stdinWriter.flush();
                        }
                        catch (IOException e) {
                            EngineGoalBase.this.getLog().error((CharSequence)"Unable to enter password", (Throwable)e);
                        }
                    }
                }), true));
                try {
                    AppCfg.main((String[])args);
                }
                catch (Throwable e) {
                    EngineGoalBase.this.getLog().error((CharSequence)"Unable to execute AppCfg", e);
                }
                finally {
                    System.setOut(outOrig);
                    System.setIn(inOrig);
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)INTERRUPTED_EXCEPTION, (Throwable)e);
        }
    }

    protected void assureSystemProperties() throws MojoExecutionException {
        String toolsJar;
        String sdk = System.getProperty("appengine.sdk.root");
        if (sdk == null) {
            if (this.sdkDir == null) {
                throw new MojoExecutionException((Object)this, "${gae.home} property not set", this.gaeProperties.getProperty("home_undefined"));
            }
            sdk = this.sdkDir;
            System.setProperty("appengine.sdk.root", sdk);
        }
        if (!new File(sdk).isDirectory()) {
            throw new MojoExecutionException((Object)this, "${gae.home} is not a directory", this.gaeProperties.getProperty("home_invalid"));
        }
        String classpath = System.getProperty("java.class.path");
        if (!classpath.contains(toolsJar = this.sdkDir + "/lib/appengine-tools-api.jar")) {
            System.setProperty("java.class.path", classpath + File.pathSeparator + toolsJar);
        }
    }

    protected final List<String> getAppCfgArgs() {
        List<String> args = this.getCommonArgs();
        this.addEmailOption(args);
        this.addStringOption(args, "--host=", this.hostString);
        this.addProxyOption(args);
        this.addBooleanOption(args, "--passin", this.passIn);
        if (!this.passIn) {
            this.addBooleanOption(args, "--disable_prompt", this.settings.getInteractiveMode() == false);
        }
        this.addBooleanOption(args, "--enable_jar_splitting", this.splitJars);
        this.addBooleanOption(args, "--retain_upload_dir", this.keepTempUploadDir);
        return args;
    }

    protected final List<String> getCommonArgs() {
        ArrayList<String> args = new ArrayList<String>(8);
        args.add("--sdk_root=" + this.sdkDir);
        this.addStringOption(args, "--server=", this.uploadServer);
        return args;
    }

    private void addEmailOption(List<String> args) {
        if (this.hasServerSettings() && this.emailAccount == null) {
            this.addStringOption(args, "--email=", this.settings.getServer(this.serverId).getUsername());
            if (this.settings.getServer(this.serverId).getPassword() != null) {
                this.passIn = true;
            }
        } else {
            this.addStringOption(args, "--email=", this.emailAccount);
        }
    }

    private void addProxyOption(List<String> args) {
        if (this.hasServerSettings() && this.proxy == null) {
            Proxy activCfgProxy = this.settings.getActiveProxy();
            if (activCfgProxy != null) {
                this.addStringOption(args, "--proxy=", activCfgProxy.getHost() + ":" + activCfgProxy.getPort());
            }
        } else {
            this.addStringOption(args, "--proxy=", this.proxy);
        }
    }

    private final void addBooleanOption(List<String> args, String key, boolean var) {
        if (var) {
            args.add(key);
        }
    }

    private final void addStringOption(List<String> args, String key, String var) {
        if (var != null && var.length() > 0) {
            args.add(key + var);
        }
    }
}

