/*
 * Decompiled with CFR 0.152.
 */
package net.kindleit.gae;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.kindleit.gae.EngineGoalBase;
import net.kindleit.gae.runner.KickStartRunner;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartGoal
extends EngineGoalBase {
    private ArtifactResolver resolver;
    private Set<Artifact> plugins;
    private ArtifactRepository localRepo;
    private List<ArtifactRepository> remoteRepos;
    protected int port;
    protected String address;
    protected boolean disableUpdateCheck;
    protected List<String> jvmFlags;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--address=" + this.address);
        arguments.add("--port=" + this.port);
        if (this.disableUpdateCheck) {
            arguments.add("--disable_update_check");
        }
        if (this.jvmFlags != null) {
            for (String jvmFlag : this.jvmFlags) {
                arguments.add("--jvm_flag=" + jvmFlag);
            }
        }
        arguments.add(this.appDir);
        this.runKickStart("com.google.appengine.tools.development.DevAppServerMain", arguments.toArray(new String[0]));
    }

    protected final void runKickStart(String startClass, String ... commandArguments) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(startClass);
        args.addAll(this.getCommonArgs());
        args.addAll(Arrays.asList(commandArguments));
        this.assureSystemProperties();
        try {
            this.resolveArtifacts(this.plugins);
            KickStartRunner.createRunner(this.wait, this.plugins, this.gaeProperties, this.getLog()).start(this.monitorPort, this.monitorKey, args);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected final void resolveArtifacts(Set<Artifact> artifacts) throws MojoExecutionException {
        for (Artifact pluginA : artifacts) {
            try {
                this.resolver.resolve(pluginA, this.remoteRepos, this.localRepo);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Failure Resolving Artifacts", (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("Failure Resolving Artifacts", (Exception)((Object)e));
            }
        }
    }
}

