/*
 * Decompiled with CFR 0.152.
 */
package net.kindleit.gae;

import java.io.File;
import java.util.List;
import net.kindleit.gae.EngineGoalBase;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class UnpackGoal
extends EngineGoalBase {
    private static final String SDK_ARTIFACT_ID = "appengine-java-sdk";
    private static final String SDK_GROUPID = "com.google.appengine";
    protected ArtifactFactory factory;
    protected ArtifactResolver artifactResolver;
    protected List<?> remoteRepos;
    protected ArtifactRepository localRepo;
    protected ArchiverManager archiverManager;
    protected String unpackVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Artifact sdkArtifact = this.factory.createArtifact(SDK_GROUPID, SDK_ARTIFACT_ID, this.unpackVersion, "", "zip");
            this.artifactResolver.resolve(sdkArtifact, this.remoteRepos, this.localRepo);
            File sdkLocation = sdkArtifact.getFile().getParentFile();
            this.getLog().info((CharSequence)("Extracting GAE SDK file: " + sdkArtifact.getFile().getAbsolutePath()));
            this.getLog().info((CharSequence)("To path: " + sdkLocation.getAbsolutePath()));
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(sdkArtifact.getFile());
            unArchiver.setSourceFile(sdkArtifact.getFile());
            unArchiver.setDestDirectory(sdkLocation);
            unArchiver.extract();
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)"can't resolve parent pom", (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().error((CharSequence)"can't resolve parent pom", (Throwable)e);
        }
        catch (NoSuchArchiverException e) {
            this.getLog().error((CharSequence)"can't find archiver for the SDK download", (Throwable)e);
        }
        catch (ArchiverException e) {
            this.getLog().error((CharSequence)"can't extract the SDK archive", (Throwable)e);
        }
    }
}

