/*
 * Decompiled with CFR 0.152.
 */
package net.kindleit.gae.runner;

import com.google.appengine.tools.KickStart;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class AppEnginePluginMonitor
implements Runnable {
    private final String key;
    private ServerSocket serverSocket;

    public AppEnginePluginMonitor(int port, String key) throws IOException {
        if (port <= 0) {
            throw new IllegalStateException("Bad stop port");
        }
        if (key == null) {
            throw new IllegalStateException("Bad stop key");
        }
        this.key = key;
        this.serverSocket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
        this.serverSocket.setReuseAddress(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block20: while (this.serverSocket != null) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                socket.setSoLinger(false, 0);
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                OutputStream out = socket.getOutputStream();
                if (!this.key.equals(in.readLine())) continue;
                Commands cmd = Commands.valueOf(in.readLine());
                if (cmd == null) {
                    out.write("Unsupported monitor operation".getBytes());
                    continue;
                }
                switch (cmd) {
                    case STOP: {
                        this.executeStop(socket, out);
                        continue block20;
                    }
                }
            }
            catch (Exception e) {}
            continue;
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                continue;
            }
            break;
        }
        return;
    }

    private void executeStop(Socket socket, OutputStream out) {
        try {
            out.write("Engine stopped".getBytes());
            socket.close();
            try {
                this.serverSocket.close();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            this.serverSocket = null;
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        int stopPort = Integer.valueOf(System.getProperty("monitor.port"));
        String stopKey = System.getProperty("monitor.key");
        try {
            Thread monitor = new Thread(new AppEnginePluginMonitor(stopPort, stopKey));
            monitor.setName("StopAppEnginePluginMonitor");
            monitor.start();
            KickStart.main((String[])args);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Commands {
        STOP;

    }
}

