/*
 * Decompiled with CFR 0.152.
 */
package net.kindleit.gae.runner;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.kindleit.gae.runner.AppEnginePluginMonitor;
import net.kindleit.gae.runner.KickStartExecutionException;
import net.kindleit.gae.runner.KickStartRunner;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BackgroundKickStartRunner
extends KickStartRunner {
    private final String pluginPath;
    private final Log log;
    private Thread thread;
    private volatile Exception thrown;

    public BackgroundKickStartRunner(Set<Artifact> artifacts, Properties gaeProperties, Log log) throws KickStartExecutionException {
        this.log = log;
        this.pluginPath = this.getPluginPath(artifacts, gaeProperties);
    }

    @Override
    public synchronized void start(int monitorPort, String monitorKey, List<String> args) throws KickStartExecutionException {
        if (this.thread != null) {
            throw new IllegalStateException("Already started");
        }
        this.thread = this.setupCommandLine(monitorPort, monitorKey, args);
        this.thread.start();
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            this.thrown = e;
        }
        if (this.thrown != null) {
            throw new KickStartExecutionException(this.thrown);
        }
    }

    private Thread setupCommandLine(int monitorPort, String monitorKey, List<String> args) {
        final Commandline commandline = new Commandline("java");
        String classPath = System.getProperty("java.class.path") + File.pathSeparator + this.pluginPath;
        commandline.createArg().setValue("-ea");
        commandline.createArg().setValue("-cp");
        commandline.createArg().setValue(classPath);
        commandline.createArg().setValue("-Dmonitor.port=" + monitorPort);
        commandline.createArg().setValue("-Dmonitor.key=" + monitorKey);
        commandline.createArg().setValue("-Dappengine.sdk.root=" + System.getProperty("appengine.sdk.root"));
        commandline.createArg().setValue(AppEnginePluginMonitor.class.getName());
        commandline.addArguments(args.toArray(new String[args.size()]));
        final StreamConsumer outConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                BackgroundKickStartRunner.this.consumeOutputLine(line);
            }
        };
        final StreamConsumer errConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                BackgroundKickStartRunner.this.consumeErrorLine(line);
            }
        };
        return new Thread(new Runnable(){

            public void run() {
                try {
                    CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)outConsumer, (StreamConsumer)errConsumer);
                }
                catch (Exception e) {
                    BackgroundKickStartRunner.this.setThrown(e);
                }
            }
        });
    }

    private synchronized void consumeOutputLine(String line) {
        System.out.println(line);
        if (line.contains("The server is running")) {
            this.notify();
        }
    }

    private synchronized void consumeErrorLine(String line) {
        System.err.println(line);
        if (line.contains("The server is running")) {
            this.notify();
        }
    }

    private synchronized void setThrown(Exception thrown) {
        this.thrown = thrown;
        this.notify();
    }

    private String getPluginPath(Set<Artifact> artifacts, Properties gaeProperties) throws KickStartExecutionException {
        String groupId = gaeProperties.getProperty("plugin.groupId");
        String artifactId = gaeProperties.getProperty("plugin.artifactId");
        for (Artifact a : artifacts) {
            if (!groupId.equals(a.getGroupId()) || !artifactId.equals(a.getArtifactId())) continue;
            try {
                return a.getFile().getCanonicalPath();
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
                throw new KickStartExecutionException(e);
            }
        }
        throw new KickStartExecutionException("Plugin not found");
    }
}

