/*
 * Decompiled with CFR 0.152.
 */
package net.kindleit.gae;

import java.io.File;
import java.util.List;
import net.kindleit.gae.EngineGoalBase;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class UnpackGoal
extends EngineGoalBase {
    private static final String APPENGINE_API_ARTIFACTID = "appengine-api-1.0-sdk";
    private static final String APPENGINE_API_GROUPID = "com.google.appengine";
    private static final String SDK_ARTIFACT_ID = "appengine-java-sdk";
    private static final String SDK_GROUPID = "com.google.appengine";
    protected ArtifactFactory factory;
    private List<Artifact> pluginArtifacts;
    protected ArtifactResolver artifactResolver;
    protected List<?> remoteRepos;
    protected ArtifactRepository localRepo;
    protected ArchiverManager archiverManager;
    protected String unpackVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.unpackVersion = this.versionHeuristics();
            Artifact sdkArtifact = this.factory.createArtifact("com.google.appengine", SDK_ARTIFACT_ID, this.unpackVersion, "", "zip");
            File sdkDestination = new File(this.sdkDir);
            if (sdkDestination.exists()) {
                this.getLog().info((CharSequence)String.format("Assuming %s %s at %s.", sdkArtifact.getArtifactId(), sdkArtifact.getBaseVersion(), sdkDestination.getAbsolutePath()));
            } else {
                this.extractSDK(sdkArtifact);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoFailureException("can't resolve parent pom", (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoFailureException("can't resolve parent pom", (Throwable)e);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("can't find archiver for the SDK download", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("can't extract the SDK archive", (Exception)((Object)e));
        }
    }

    void extractSDK(Artifact sdkArtifact) throws ArtifactResolutionException, ArtifactNotFoundException, NoSuchArchiverException, ArchiverException {
        this.artifactResolver.resolve(sdkArtifact, this.remoteRepos, this.localRepo);
        File sdkLocation = sdkArtifact.getFile().getParentFile();
        this.getLog().info((CharSequence)String.format("Extracting GAE SDK %s to %s ", sdkArtifact.getFile().getAbsolutePath(), sdkLocation.getAbsolutePath()));
        UnArchiver unArchiver = this.archiverManager.getUnArchiver(sdkArtifact.getFile());
        unArchiver.setSourceFile(sdkArtifact.getFile());
        unArchiver.setDestDirectory(sdkLocation);
        unArchiver.extract();
    }

    private String versionHeuristics() {
        if (this.unpackVersion == null || this.unpackVersion.isEmpty()) {
            for (Artifact pa : this.pluginArtifacts) {
                if (!"com.google.appengine".equals(pa.getGroupId()) || !APPENGINE_API_ARTIFACTID.equals(pa.getArtifactId())) continue;
                return pa.getVersion();
            }
        }
        return this.unpackVersion;
    }
}

