/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.config;

import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemConfiguration
extends CompositeConfiguration {
    private static Logger logger = LoggerFactory.getLogger(SystemConfiguration.class);

    @Inject
    public SystemConfiguration(@Named(value="kangaroo_external_configuration") Iterable<Configuration> configurations) {
        logger.debug("Building System Configuration");
        configurations.forEach(arg_0 -> ((SystemConfiguration)this).addConfiguration(arg_0));
        if (this.getNumberOfConfigurations() == 1) {
            this.addConfiguration((Configuration)new org.apache.commons.configuration.SystemConfiguration());
        }
        this.configureGlobal();
    }

    public TimeZone getTimezone() {
        return TimeZone.getTimeZone(this.getString("global.timezone", "UTC"));
    }

    private void configureGlobal() {
        logger.debug("Setting default timezone....");
        TimeZone.setDefault(this.getTimezone());
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)((ClassBinding)this.bind(SystemConfiguration.class).to(SystemConfiguration.class)).to(Configuration.class)).named("system")).in(Singleton.class);
        }
    }
}

