/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.exception;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import org.apache.http.impl.EnglishReasonPhraseCatalog;

public final class ErrorResponseBuilder {
    private final ErrorResponse response = new ErrorResponse();

    public static ErrorResponseBuilder from(Response.Status httpStatus) {
        return ErrorResponseBuilder.from(httpStatus, ErrorResponseBuilder.messageForCode(httpStatus), ErrorResponseBuilder.errorForCode(httpStatus));
    }

    public static ErrorResponseBuilder from(Response.Status httpStatus, String message) {
        return ErrorResponseBuilder.from(httpStatus, message, ErrorResponseBuilder.errorForCode(httpStatus));
    }

    public static ErrorResponseBuilder from(Response.Status httpStatus, String message, String error) {
        ErrorResponseBuilder builder = new ErrorResponseBuilder();
        builder.response.httpStatus = httpStatus;
        builder.response.error = error;
        builder.response.errorDescription = message;
        return builder;
    }

    public static ErrorResponseBuilder from(JsonParseException e) {
        return ErrorResponseBuilder.from(Response.Status.BAD_REQUEST, e.getMessage(), ErrorResponseBuilder.errorForCode(Response.Status.BAD_REQUEST));
    }

    public static ErrorResponseBuilder from(WebApplicationException e) {
        return ErrorResponseBuilder.from(Response.Status.fromStatusCode((int)e.getResponse().getStatus()), e.getMessage());
    }

    public static ErrorResponseBuilder from(KangarooException ke) {
        return ErrorResponseBuilder.from(ke.getCode());
    }

    public static ErrorResponseBuilder from(KangarooException.ErrorCode code) {
        return ErrorResponseBuilder.from(code.getHttpStatus(), code.getErrorDescription(), code.getError());
    }

    public static ErrorResponseBuilder from(ConstraintViolationException e) {
        Set violations = e.getConstraintViolations();
        if (violations.size() > 0) {
            return ErrorResponseBuilder.from(Response.Status.BAD_REQUEST, ((ConstraintViolation)violations.iterator().next()).getMessage());
        }
        return ErrorResponseBuilder.from(Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static ErrorResponseBuilder from(Throwable e) {
        return ErrorResponseBuilder.from(Response.Status.INTERNAL_SERVER_ERROR);
    }

    private static String messageForCode(Response.Status httpStatus) {
        return EnglishReasonPhraseCatalog.INSTANCE.getReason(httpStatus.getStatusCode(), Locale.getDefault());
    }

    private static String errorForCode(Response.Status httpStatus) {
        return ErrorResponseBuilder.messageForCode(httpStatus).toLowerCase().replace(" ", "_");
    }

    public ErrorResponseBuilder addHeader(String header, String value) {
        this.response.headers.put(header, value);
        return this;
    }

    public Response build() {
        Response.ResponseBuilder b = Response.status((Response.Status)this.response.httpStatus).type("application/json").entity((Object)this.response);
        this.response.headers.forEach((arg_0, arg_1) -> ((Response.ResponseBuilder)b).header(arg_0, arg_1));
        return b.build();
    }

    public static final class ErrorResponse {
        private String error = "";
        @JsonProperty(value="error_description")
        private String errorDescription = "";
        @JsonIgnore
        private Response.Status httpStatus = Response.Status.BAD_REQUEST;
        @JsonIgnore
        private Map<String, String> headers = new HashMap<String, String>();

        private ErrorResponse() {
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public Response.Status getHttpStatus() {
            return this.httpStatus;
        }
    }
}

