/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.krotscheck.kangaroo.common.hibernate.entity.ConfigurationEntry;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public final class HibernateConfiguration
extends AbstractConfiguration
implements Configuration {
    private final SessionFactory factory;
    private final String section;
    private SortedMap<String, Object> configurationCache;

    public HibernateConfiguration(SessionFactory factory, String section) {
        this.factory = factory;
        this.section = section;
    }

    protected void addPropertyDirect(String key, Object value) {
        ConfigurationEntry e = new ConfigurationEntry();
        e.setSection(this.section);
        e.setKey(key);
        e.setValue(String.valueOf(value));
        Session s = this.factory.openSession();
        s.getTransaction().begin();
        s.save((Object)e);
        s.getTransaction().commit();
        this.configurationCache = null;
    }

    public boolean isEmpty() {
        return this.getConfiguration().isEmpty();
    }

    public boolean containsKey(String key) {
        return this.getConfiguration().containsKey(key);
    }

    public Object getProperty(String key) {
        return this.getConfiguration().get(key);
    }

    protected void clearPropertyDirect(String key) {
        Session s = this.factory.openSession();
        Criteria c = s.createCriteria(ConfigurationEntry.class);
        c.add((Criterion)Restrictions.eq((String)"section", (Object)this.section));
        c.add((Criterion)Restrictions.eq((String)"key", (Object)key));
        s.getTransaction().begin();
        for (ConfigurationEntry entry : c.list()) {
            s.delete((Object)entry);
        }
        s.getTransaction().commit();
        s.close();
        this.configurationCache = null;
    }

    public void clear() {
        this.fireEvent(4, null, null, true);
        Session s = this.factory.openSession();
        Criteria c = s.createCriteria(ConfigurationEntry.class);
        c.add((Criterion)Restrictions.eq((String)"section", (Object)this.section));
        s.getTransaction().begin();
        for (ConfigurationEntry entry : c.list()) {
            s.delete((Object)entry);
        }
        s.getTransaction().commit();
        s.close();
        this.configurationCache = null;
        this.fireEvent(4, null, null, false);
    }

    public Iterator<String> getKeys() {
        return this.getConfiguration().keySet().iterator();
    }

    private SortedMap<String, Object> getConfiguration() {
        if (this.configurationCache == null) {
            Session s = this.factory.openSession();
            Criteria c = s.createCriteria(ConfigurationEntry.class);
            c.add((Criterion)Restrictions.eq((String)"section", (Object)this.section));
            List entries = c.list();
            TreeMap<String, String> values = new TreeMap<String, String>();
            for (ConfigurationEntry entry : entries) {
                values.put(entry.getKey(), entry.getValue());
            }
            s.close();
            this.configurationCache = Collections.unmodifiableSortedMap(values);
        }
        return this.configurationCache;
    }
}

