/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.math.BigInteger;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import net.krotscheck.kangaroo.common.hibernate.entity.ICreatedDateEntity;
import net.krotscheck.kangaroo.common.hibernate.entity.IModifiedDateEntity;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilterFactory;
import org.apache.lucene.analysis.charfilter.MappingCharFilterFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.miscellaneous.RemoveDuplicatesTokenFilterFactory;
import org.apache.lucene.analysis.miscellaneous.TrimFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;

@MappedSuperclass
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
@JsonIgnoreProperties(ignoreUnknown=true)
@AnalyzerDef(name="entity_analyzer", charFilters={@CharFilterDef(factory=HTMLStripCharFilterFactory.class), @CharFilterDef(factory=MappingCharFilterFactory.class, params={@Parameter(name="mapping", value="kangaroo-char-mapping.properties")})}, tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class), filters={@TokenFilterDef(factory=TrimFilterFactory.class), @TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=StopFilterFactory.class), @TokenFilterDef(factory=SnowballPorterFilterFactory.class, params={@Parameter(name="language", value="English")}), @TokenFilterDef(factory=RemoveDuplicatesTokenFilterFactory.class)})
public abstract class AbstractEntity
implements Cloneable,
IModifiedDateEntity,
ICreatedDateEntity {
    @Id
    @DocumentId
    @GenericGenerator(name="secure_random_bytes", strategy="net.krotscheck.kangaroo.common.hibernate.id.SecureRandomIdGenerator")
    @GeneratedValue(generator="secure_random_bytes")
    @Column(name="id", unique=true, nullable=false, updatable=false)
    @Type(type="net.krotscheck.kangaroo.common.hibernate.type.BigIntegerType")
    private BigInteger id = null;
    @Column(name="createdDate")
    @Type(type="net.krotscheck.kangaroo.common.hibernate.type.CalendarTimestampType")
    private Calendar createdDate;
    @Column(name="modifiedDate")
    @Type(type="net.krotscheck.kangaroo.common.hibernate.type.CalendarTimestampType")
    private Calendar modifiedDate;

    public final BigInteger getId() {
        return this.id;
    }

    public final void setId(BigInteger id) {
        this.id = id;
    }

    @Override
    public final Calendar getCreatedDate() {
        if (this.createdDate == null) {
            return null;
        }
        return (Calendar)this.createdDate.clone();
    }

    @Override
    public final void setCreatedDate(Calendar date) {
        this.createdDate = (Calendar)date.clone();
    }

    @Override
    public final Calendar getModifiedDate() {
        if (this.modifiedDate == null) {
            return null;
        }
        return (Calendar)this.modifiedDate.clone();
    }

    @Override
    public final void setModifiedDate(Calendar date) {
        this.modifiedDate = (Calendar)date.clone();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isInstance(o)) {
            return false;
        }
        AbstractEntity other = (AbstractEntity)o;
        if (this.id == null) {
            return false;
        }
        return this.id.equals(other.getId());
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).append((Object)this.getClass().getName()).toHashCode();
    }

    public final String toString() {
        return String.format("%s [id=%s]", this.getClass().getCanonicalName(), IdUtil.toString(this.getId()));
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

