/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.factory;

import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FulltextSessionFactory
implements DisposableSupplier<FullTextSession> {
    private static Logger logger = LoggerFactory.getLogger(FulltextSessionFactory.class);
    private Session hibernateSession;

    @Inject
    public FulltextSessionFactory(@Named(value="root_session") SessionImpl session) {
        this.hibernateSession = session;
    }

    public FullTextSession get() {
        logger.trace("Creating hibernate fulltext session.");
        return Search.getFullTextSession((Session)this.hibernateSession);
    }

    public void dispose(FullTextSession session) {
        if (session != null && session.isOpen()) {
            logger.trace("Disposing of hibernate fulltext session.");
            session.close();
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((SupplierClassBinding)this.bindFactory(FulltextSessionFactory.class).to(FullTextSession.class)).in(RequestScoped.class);
        }
    }
}

