/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.factory;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.krotscheck.kangaroo.server.Config;
import org.apache.commons.configuration.Configuration;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HibernateServiceRegistryFactory
implements DisposableSupplier<ServiceRegistry> {
    private static Logger logger = LoggerFactory.getLogger(HibernateServiceRegistryFactory.class);
    private final Map<String, String> defaultSettings;

    @Inject
    public HibernateServiceRegistryFactory(@Named(value="system") Configuration config) throws IOException {
        String workingDir = config.getString(Config.WORKING_DIR.getKey(), Config.WORKING_DIR.getValue());
        this.defaultSettings = new HashMap<String, String>();
        this.defaultSettings.put("hibernate.connection.url", String.format("jdbc:h2:file:%s/h2.db", workingDir));
        this.defaultSettings.put("hibernate.connection.username", "oid");
        this.defaultSettings.put("hibernate.connection.password", "oid");
        this.defaultSettings.put("hibernate.connection.driver_class", "org.h2.Driver");
        this.defaultSettings.put("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        File indexDir = new File(workingDir, "lucene_indexes");
        if (!Files.exists(indexDir.toPath(), new LinkOption[0])) {
            Files.createDirectory(indexDir.toPath(), new FileAttribute[0]);
        }
        this.defaultSettings.put("hibernate.search.default.directory_provider", "filesystem");
        this.defaultSettings.put("hibernate.search.default.indexBase", indexDir.getAbsolutePath());
    }

    public ServiceRegistry get() {
        logger.trace("Service Registry provide");
        return new StandardServiceRegistryBuilder().configure().applySettings(this.defaultSettings).applySettings(System.getenv()).applySettings((Map)System.getProperties()).build();
    }

    public void dispose(ServiceRegistry serviceRegistry) {
        StandardServiceRegistryBuilder.destroy((ServiceRegistry)serviceRegistry);
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((SupplierClassBinding)this.bindFactory(HibernateServiceRegistryFactory.class).to(ServiceRegistry.class)).in(Singleton.class);
        }
    }
}

