/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.id;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Arrays;
import javax.inject.Singleton;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.glassfish.jersey.internal.inject.Custom;

@Provider
@Singleton
@Custom
public final class Base16BigIntegerConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> clazz, Type type, Annotation[] annotations) {
        if (!clazz.getName().equals(BigInteger.class.getName())) {
            return null;
        }
        Boolean isPathParam = Arrays.stream(annotations).filter(a -> a instanceof PathParam).count() > 0L;
        Boolean isQueryParam = Arrays.stream(annotations).filter(a -> a instanceof QueryParam).count() > 0L;
        if (!isPathParam.booleanValue() && !isQueryParam.booleanValue()) {
            return null;
        }
        return new ParamConverter<T>(){

            public T fromString(String value) {
                try {
                    return IdUtil.fromString(value);
                }
                catch (Exception e) {
                    throw new NotFoundException();
                }
            }

            public String toString(T value) {
                return IdUtil.toString((BigInteger)value);
            }
        };
    }
}

