/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.transaction;

import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;

@Priority(value=5000)
@Transactional
public final class TransactionFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private final Provider<Session> sessionProvider;

    @Inject
    public TransactionFilter(Provider<Session> sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Session s = (Session)this.sessionProvider.get();
        s.getTransaction().begin();
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Session s = (Session)this.sessionProvider.get();
        Transaction t = s.getTransaction();
        try {
            if (t.getStatus().equals((Object)TransactionStatus.ACTIVE)) {
                s.getTransaction().commit();
            }
        }
        catch (HibernateException he) {
            t.rollback();
            Response r = ErrorResponseBuilder.from(he).build();
            responseContext.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            responseContext.setEntity(r.getEntity());
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(TransactionFilter.class).to(ContainerRequestFilter.class)).to(ContainerResponseFilter.class)).in(Singleton.class);
        }
    }
}

