/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.text.DateFormat;
import java.util.function.Supplier;
import net.krotscheck.kangaroo.common.jackson.types.KangarooCustomTypesModule;

public final class ObjectMapperFactory
implements Supplier<ObjectMapper> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public ObjectMapper get() {
        return MAPPER;
    }

    static {
        MAPPER.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, true);
        MAPPER.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
        MAPPER.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        MAPPER.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        MAPPER.setDateFormat((DateFormat)new ISO8601DateFormat());
        JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector(MAPPER.getTypeFactory());
        JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair combinedIntrospector = new AnnotationIntrospectorPair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
        MAPPER.setAnnotationIntrospector((AnnotationIntrospector)combinedIntrospector);
        MAPPER.registerModule((Module)new KangarooCustomTypesModule());
    }
}

