/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.server.keystore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import net.krotscheck.kangaroo.server.keystore.FSKeystoreProvider;
import net.krotscheck.kangaroo.server.keystore.IKeystoreProvider;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratedKeystoreProvider
implements IKeystoreProvider {
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final X500Name X_500_NAME = new X500Name("C=US,ST=Washington,L=Seattle,O=Kangaroo,OU=Kangaroo,CN=localhost");
    private static final BigInteger SERIAL = BigInteger.valueOf(new SecureRandom().nextInt());
    private static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 2592000000L);
    private static final Date NOT_AFTER = new Date(System.currentTimeMillis() + 315360000000L);
    private static Logger logger = LoggerFactory.getLogger(GeneratedKeystoreProvider.class);
    private final FSKeystoreProvider generatedProvider;
    private final String keystorePath;
    private final String keystorePass;
    private final String certificatePass;
    private final String alias;

    public GeneratedKeystoreProvider(String workingDirectory) {
        this(workingDirectory, "kangaroo", "kangaroo", "kangaroo");
    }

    public GeneratedKeystoreProvider(String workingDirectory, String keystorePass, String certificatePass, String alias) {
        this.keystorePath = Paths.get(workingDirectory, "generated.p12").toAbsolutePath().toString();
        this.generatedProvider = new FSKeystoreProvider(this.keystorePath, keystorePass, KEYSTORE_TYPE);
        this.keystorePass = keystorePass;
        this.certificatePass = certificatePass;
        this.alias = alias;
    }

    private boolean doesKeystoreExist() {
        File ks = new File(this.keystorePath);
        return ks.exists();
    }

    protected X509v3CertificateBuilder getCertificateBuilder(KeyPair keyPair) throws NoSuchAlgorithmException {
        logger.info("Generating Certificate Builder");
        byte[] publicKey = keyPair.getPublic().getEncoded();
        SubjectPublicKeyInfo pki = SubjectPublicKeyInfo.getInstance((Object)publicKey);
        return new X509v3CertificateBuilder(X_500_NAME, SERIAL, NOT_BEFORE, NOT_AFTER, X_500_NAME, pki);
    }

    protected ContentSigner getCertificateSigner(KeyPair keyPair) throws NoSuchAlgorithmException, IOException, OperatorCreationException {
        logger.info("Generating Certificate Signer");
        byte[] privateKey = keyPair.getPrivate().getEncoded();
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256WithRSAEncryption");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        return new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(PrivateKeyFactory.createKey((byte[])privateKey));
    }

    @Override
    public KeyStore getKeyStore() {
        if (!this.doesKeystoreExist()) {
            this.generateKeystore();
        }
        return this.generatedProvider.getKeyStore();
    }

    protected void generateKeystore() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(null, this.keystorePass.toCharArray());
            logger.info("Generating Keypair");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey key = keyPair.getPrivate();
            logger.info("Generating x509 Certificate");
            ContentSigner signer = this.getCertificateSigner(keyPair);
            X509v3CertificateBuilder builder = this.getCertificateBuilder(keyPair);
            X509CertificateHolder holder = builder.build(signer);
            X509Certificate cert = new JcaX509CertificateConverter().getCertificate(holder);
            Certificate[] chain = new Certificate[]{cert};
            keyStore.setKeyEntry(this.alias, key, this.certificatePass.toCharArray(), chain);
            File targetFile = new File(this.keystorePath);
            FileOutputStream os = new FileOutputStream(targetFile);
            keyStore.store(os, this.keystorePass.toCharArray());
        }
        catch (Exception kse) {
            throw new RuntimeException(kse);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        this.getKeyStore();
        this.generatedProvider.writeTo(outputStream);
    }
}

