/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.util;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtil {
    private static Logger logger = LoggerFactory.getLogger(RequestUtil.class);

    private RequestUtil() {
    }

    public static String getCORSRequestedMethod(ContainerRequestContext request) {
        MultivaluedMap headers = request.getHeaders();
        return (String)headers.getFirst((Object)"Access-Control-Request-Method");
    }

    public static List<String> getCORSRequestedHeaders(ContainerRequestContext request) {
        MultivaluedMap headers = request.getHeaders();
        String rawHeaders = (String)headers.getFirst((Object)"Access-Control-Request-Headers");
        if (Strings.isNullOrEmpty((String)rawHeaders)) {
            return Collections.emptyList();
        }
        return Arrays.stream(rawHeaders.split(",")).map(String::trim).map(String::toLowerCase).filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.toList());
    }

    public static URI getOrigin(ContainerRequestContext request) {
        MultivaluedMap headers = request.getHeaders();
        String rawHost = (String)headers.getFirst((Object)"Origin");
        try {
            return new URIBuilder(rawHost).build();
        }
        catch (NullPointerException | URISyntaxException use) {
            return null;
        }
    }

    public static URI getReferer(ContainerRequestContext request) {
        MultivaluedMap headers = request.getHeaders();
        String rawHost = (String)headers.getFirst((Object)"Referer");
        try {
            return new URIBuilder(rawHost).build();
        }
        catch (NullPointerException | URISyntaxException use) {
            return null;
        }
    }

    public static URI getHost(ContainerRequestContext request) {
        MultivaluedMap headers = request.getHeaders();
        String rawHost = (String)headers.getFirst((Object)"Host");
        try {
            String[] parts = rawHost.split(":");
            URIBuilder builder = new URIBuilder();
            builder.setScheme(request.getUriInfo().getRequestUri().getScheme());
            builder.setHost(parts[0]);
            if (parts.length > 1) {
                builder.setPort(Integer.valueOf(parts[1]).intValue());
            }
            return builder.build();
        }
        catch (NullPointerException | NumberFormatException | URISyntaxException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    public static URI getForwardedHost(ContainerRequestContext request) {
        MultivaluedMap headers = request.getHeaders();
        String rawForwardedHost = (String)headers.getFirst((Object)"X-Forwarded-Host");
        String rawForwardedPort = (String)headers.getFirst((Object)"X-Forwarded-Port");
        String rawForwardedProto = (String)headers.getFirst((Object)"X-Forwarded-Proto");
        try {
            Integer forwardedPort = rawForwardedPort == null ? -1 : Integer.valueOf(rawForwardedPort, 10);
            URI result = new URIBuilder().setHost(rawForwardedHost).setPort(forwardedPort.intValue()).setScheme(rawForwardedProto).build();
            return Strings.isNullOrEmpty((String)result.toString()) ? null : result;
        }
        catch (NumberFormatException | URISyntaxException use) {
            logger.debug("Cannot parse forwarded header.", (Throwable)use);
            return null;
        }
    }

    public static Boolean isCrossOriginRequest(ContainerRequestContext request) throws BadRequestException {
        URI target;
        URI origin = RequestUtil.getOrigin(request);
        URI referer = RequestUtil.getReferer(request);
        URI host = RequestUtil.getHost(request);
        URI forwardedHost = RequestUtil.getForwardedHost(request);
        try {
            referer = new URIBuilder().setScheme(referer.getScheme()).setHost(referer.getHost()).setPort(referer.getPort()).build();
        }
        catch (NullPointerException | URISyntaxException e) {
            referer = null;
        }
        URI source = origin == null ? referer : origin;
        URI uRI = target = forwardedHost == null ? host : forwardedHost;
        if (source == null) {
            return false;
        }
        return !source.equals(target);
    }
}

