/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.factory;

import javax.inject.Inject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HibernateSessionFactory
implements DisposableSupplier<Session> {
    private static Logger logger = LoggerFactory.getLogger(HibernateSessionFactory.class);
    private SessionFactory factory;

    @Inject
    public HibernateSessionFactory(SessionFactory sessionFactory) {
        this.factory = sessionFactory;
    }

    public Session get() {
        logger.trace("Creating hibernate session.");
        return this.factory.openSession();
    }

    public void dispose(Session session) {
        if (session != null && session.isConnected()) {
            logger.trace("Disposing of hibernate session.");
            session.close();
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(HibernateSessionFactory.class).to(Session.class)).to(SessionImpl.class)).named("root_session")).in(RequestScoped.class);
        }
    }
}

