/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.common.hibernate.type;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

public final class URITypeDescriptor
extends AbstractTypeDescriptor<URI> {
    public static final URITypeDescriptor INSTANCE = new URITypeDescriptor();

    public URITypeDescriptor() {
        super(URI.class);
    }

    public String toString(URI value) {
        return value.toString();
    }

    public URI fromString(String string) {
        try {
            return UriBuilder.fromUri((String)string).build(new Object[0]);
        }
        catch (Exception e) {
            throw new HibernateException("Unable to convert string [" + string + "] to URI : " + e);
        }
    }

    public <X> X unwrap(URI value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw new HibernateException("Unknown unwrap conversion requested: URI to " + type.getName());
    }

    public <X> URI wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return this.fromString((String)value);
        }
        throw new HibernateException("Unknown wrap conversion requested: " + value.getClass().getName() + " to URI");
    }
}

